# CVE-2025-5777: The Ultimate PoC & Scanner 🚀

![Hacker GIF](https://media4.giphy.com/media/v1.Y2lkPTc5MGI3NjExNXd1aHVjd2wyYzZ1ZWNmdngxbnNzeW5jZnpyN250bDhxY3JzaDQzdCZlcD12MV9pbnRlcm5hbF9naWZfYnlfaWQmY3Q9Zw/eCqFYAVjjDksg/giphy.gif)

![CVE](https://img.shields.io/badge/CVE-2025--5777-red?style=for-the-badge)
![Severity](https://img.shields.io/badge/Severity-CRITICAL-darkred?style=for-the-badge)
![Author](https://img.shields.io/badge/Author-CyberTechAjju-blue?style=for-the-badge)
![License](https://img.shields.io/badge/License-MIT-green?style=for-the-badge) 

An advanced, powerful, and easy-to-use tool designed to detect and exploit **CVE-2025-5777 (CitrixBleed 2)**. This script not only identifies the vulnerability but also helps in demonstrating its impact by parsing human-readable information from the memory leak.

---

## What is CVE-2025-5777?

**CVE-2025-5777** is a critical memory leak vulnerability in NetScaler (formerly Citrix) ADC and Gateway products. It allows an unauthenticated, remote attacker to read chunks of sensitive data from the server's memory, such as session cookies, usernames, passwords, and other private information.

A successful attack resulting in a session cookie leak can lead to a full **Account Takeover**, completely bypassing login credentials and multi-factor authentication (MFA).

---

## ✨ Features

* **High-Speed Asynchronous Scanning:** Utilizes `asyncio` and `aiohttp` to scan multiple targets quickly and efficiently.
* **Intelligent Data Parsing:** Automatically extracts human-readable strings from raw binary memory dumps.
* **Sensitive Data Detection:** Automatically identifies and highlights high-impact patterns like session cookies (`NSC_AAAC`).
* **Comprehensive Reporting:** Saves all findings to a clean `leaks.txt` file for easy analysis.

---

## ⚠️ Disclaimer

This tool is created for **educational and authorized bug bounty purposes ONLY**. Unauthorized use of this tool on any system is illegal. The developer is not responsible for any misuse or damage caused by this tool.

---

## 🎥 Video Tutorial: Finding & Exploiting

For a full, step-by-step guide on how to find and exploit vulnerabilities, I have created a detailed video. This video demonstrates the complete process, from identifying targets to executing the exploit.

**Watch the full step-by-step video guide here:**
[**Live Hacking Demo: Finding and Exploiting a Critical Vulnerability**](https://youtu.be/p3Edctu2g8M?si=lgHYp9DDRqMVdID0)

---

## 📚 Official References

* **NIST NVD:** [CVE-2025-5777 Detail](https://nvd.nist.gov/vuln/detail/CVE-2025-5777)
* **Citrix Support:** [CTX693420 Security Bulletin](https://support.citrix.com/support-home/kbsearch/article?articleNumber=CTX693420)

---

## 🙏 Credits and Acknowledgements

* **Tool Developer & Researcher:** **CyberTechAjju**
* **Original Vulnerability Research:** The foundational research and original exploit concepts for this vulnerability were published by security researchers at **Watchtwr Labs** and others in the community. This tool builds upon their essential work.

---

## 📜 License

This project is licensed under the MIT License. See the `LICENSE` file for more details.
