# CVE-2025-57389 - Reflected XSS in OpenWRT 18.06.2

## Description
A reflected cross-site scripting (XSS) vulnerability was identified in EOL Luci OpenWRT v18.06.2 on `/cgi-bin/luci/admin/system/packages` endpoint.

## Proof of Concept

1. While proxying the traffic to Burp, navigate to `http://192.168.56.2/cgi-bin/luci/admin/system/packages`,
2. Type any package name in **Filter**, submit,
3. Send the POST request to this endpoint to the repeater,
4. Inside display parameter, type the payload (present on the screenshot below),
    <img width="891" height="862" alt="1" src="https://github.com/user-attachments/assets/207560f3-cddf-4d0b-938b-47a5eb99d6d5" />
5. Send, right-click in Repeater tab, Request in browser. Copy the link into the browser
6. To execute the payload, click **Reset button**
   <img width="964" height="873" alt="2" src="https://github.com/user-attachments/assets/da74bd55-6142-4b7f-afb8-72863782fc82" />

## Root Cause
The root cause of the vulnerability is insufficient input sanitization, which allows threat actor to break out of the string and directly execute JavaScript payload.

## Impact
Exploitation of this vulnerability could allow the attacker to exfiltrate session tokens (cookies), potentially leading to account takeover.

## Affected Version Details
Luci - OpenWRT 18.06.2, branch (git-19.020.41695-6f6641d) - [source code](https://github.com/openwrt/luci/blob/20b3600d4d64bf60588cf4975c7a62104411870e/modules/luci-mod-admin-full/luasrc/view/admin_system/packages.htm#L73)

## References
- https://portswigger.net/web-security/cross-site-scripting/contexts
