# PX4 Military UAV Autopilot <=1.12.3 Stack Buffer Overflow Exploit (CVE-2025-5640)

**Author:** Mohammed Idrees Banyamer (@banyamer_security)  
**GitHub:** [https://github.com/mbanyamer](https://github.com/mbanyamer)  
**Date:** 2025-06-21  
**Tested on:** Ubuntu 20.04 LTS + PX4 SITL (jMAVSim)  
**CVE:** CVE-2025-5640  
**Type:** Denial of Service (DoS) via Stack Buffer Overflow  
**Platform:** Cross-platform (Military UAVs / PX4 SITL / Linux-based autopilot ground station)  
**Author Country:** Jordan

---

## Description

A stack-based buffer overflow vulnerability exists in PX4 Military UAV Autopilot versions <= 1.12.3.  
The vulnerability is triggered when handling a malformed MAVLink message of type `TRAJECTORY_REPRESENTATION_WAYPOINTS`.  
An attacker with access to the MAVLink communication channel can send a crafted packet to crash the autopilot, potentially disrupting military UAV operations.

This repository contains a proof-of-concept (PoC) exploit that sends a malicious MAVLink UDP packet to trigger the vulnerability and cause a denial of service (crash) in the PX4 autopilot.

---
## Usage:
    python3 px4_military_exploit.py [OPTIONS]

## Examples:
    # Run DoS attack on default PX4 SITL
    python3 px4_military_exploit.py --mode dos

    # Test connectivity to a real drone
    python3 px4_military_exploit.py --mode check --ip 192.168.10.10 --port 14550

Options:
    --ip        Target IP address (default: 127.0.0.1)
    --port      Target UDP port (default: 14540)
    --mode      Mode of operation: dos (default), check
    --timeout   Timeout in seconds for heartbeat (default: 5)
    --verbose   Enable verbose output

## Disclaimer:
    This PoC exploit is provided for educational and research purposes only.
    Unauthorized use against systems without permission is illegal and unethical.
    Use responsibly and ensure you have explicit authorization before testing.
"""
## Requirements

- Python 3.x  
- [pymavlink](https://github.com/ArduPilot/pymavlink) library

Install pymavlink via pip:

```bash
pip install pymavlink
