# 🚨 CVE‑2025‑55752 — Apache Tomcat Directory Traversal / RCE Regression

### 📌 Summary

A regression in Apache Tomcat introduced a **Relative Path Traversal** vulnerability when rewrite rules map query parameters into URLs. The URL is normalized before decoding, allowing attackers to bypass internal protections (such as `/WEB-INF/` or `/META-INF/`). If HTTP PUT is enabled, malicious file uploads could lead to **Remote Code Execution (RCE)**.

---

### 📋 Affected Versions

| Tomcat Branch | Vulnerable Versions |
| ------------- | ------------------- |
| 11            | 11.0.0‑M1 → 11.0.10 |
| 10.1          | 10.1.0‑M1 → 10.1.44 |
| 9.0           | 9.0.0‑M11 → 9.0.108 |
| 8.5 / EOL     | 8.5.6 → 8.5.100     |

**Mitigation:** Upgrade to **11.0.11**, **10.1.45**, or **9.0.109** (or later).

---

### ⚠️ Severity

* **CVSS v3.1 Score:** 7.5 (High)
* **Impact:** Confidentiality, Integrity, Availability — All High
* **Attack Complexity:** Moderate (requires specific rewrite rules and/or HTTP PUT enabled)

---

### 🔍 Attack Vector

1. A server uses rewrite rules mapping query parameters into URLs.
2. The URL normalization logic allows crafted path traversal sequences (`../`) to bypass protections.
3. Attackers can access restricted directories (`/WEB-INF/`, `/META-INF/`).
4. If HTTP PUT is enabled, malicious files can be uploaded and executed → RCE.

---

### Usage Examples:

**Check if path traversal to protected directories is possible:**

```
sudo python3 CVE-2025-55752.py http://target:8080 --check
```

**Attempt to upload a JSP file and test access bypass:**

```
sudo python3 CVE-2025-55752.py http://target:8080
```

**🔧 Customize the filename and payload content:**

```
sudo python3 CVE-2025-55752.py http://target:8080 --filename exploit.jsp --payload "<% out.println('PWNED'); %>"
```

---

### 🛠 Mitigation & Recommendations

✅ **Upgrade Tomcat** — Use patched versions above.
✅ **Disable HTTP PUT** — Only enable if strictly necessary.
✅ **Harden rewrite rules** — Sanitize inputs and reject traversal sequences.
✅ **Enforce access control** — Restrict protected paths and administrative endpoints.
✅ **Use WAF / logging** — Monitor for suspicious traversal or PUT requests.

---

### 🧭 Key Takeaways

* Regression vulnerabilities can reintroduce serious risks even in fixed software.
* URL rewrite logic and HTTP PUT endpoints are high-risk vectors if misconfigured.
* Regular patching, secure configuration, and monitoring are essential to prevent exploitation.

---
