# CVE-2025-55580 - SolidInvoice Stored Cross-Site Scripting (XSS) in Clients

## Summary
SolidInvoice is vulnerable to a Stored Cross-Site Scripting (XSS) issue in the Client Module. An authenticated attacker can inject arbitrary JavaScript into the application, which will then execute in users' browsers.
## Affected Versions
* **Vulnerable:** 2.3.7
* **Fixed:** 2.3.8

## Impact
Exploitation allows a malicious user to store arbitrary JavaScript in the application, which will execute in the context of other authenticated users who view the *Clients* page. If the application is deployed in a multi-user environment - for example, with multiple admins, this could lead to:
* Session hijacking
* Credential or token theft
* Phishing or social engineering attacks
* Arbitrary actions performed on behalf of another user

## Proof-of-Concept
1. Navigate to *Clients > Add Client*.
2. Enter a payload in the *Name* field with the following format:
   ```
   <script>prompt(document.cookie)</script>
   ```
3. Fill in all required fields and save the client.
4. Visit *Clients > List Clients* to trigger the script.

## Remediation
Update SolidInvoice to version **2.3.8 or later**.

## References
**Product:** https://solidinvoice.co/
