# CVE-2025-55315-repro

This repository contains a small ASP.NET Core console app to reproduce and exercise HTTP chunked-transfer and newline parsing behavior.

More information on [CVE-2025-55315](https://github.com/dotnet/aspnetcore/issues/64033).

## Contents

`Repro/Program.cs` - Console app that starts a local Kestrel server and runs two TCP-based tests. The tests send raw HTTP bytes over a `TcpClient` to exercise chunked transfer parsing and invalid newline handling across fragmented reads.

If these tests fail, you are vulernable to CVE-2025-55315 and need to update your version of .NET (versions 8, 9, and 10) or obtain post-EOL support for .NET (version 6) from [HeroDevs](https://www.herodevs.com/support/dot-net-nes).

### Passing Tests

<img width="1468" height="749" alt="image" src="https://github.com/user-attachments/assets/3dc3c652-eb78-48c1-b47a-bf63dc058ee1" />

### Failing Tests

<img width="1468" height="751" alt="image" src="https://github.com/user-attachments/assets/883de76c-6cf1-4a29-bec7-4bb033f0a163" />

## Prerequisites

.NET SDK 6+

## Build and Run

```pwsh
git clone https://github.com/sirredbeard/CVE-2025-55315-repro
cd CVE-2025-55315-repro
dotnet build CVE-2025-55315-repro.sln --framework net6.0
dotnet run --project Repro/Repro.csproj --configuration Debug --framework net6.0
```
