# CVE-2025-55188-7z-exploit
---

# 7-Zip Symlink Arbitrary File Write PoC (CVE-2025-55188)

## Description

This proof-of-concept demonstrates **CVE-2025-55188**, a vulnerability in 7-Zip versions prior to **25.01**.
The flaw occurs because 7-Zip does not properly handle **symbolic links** during extraction, allowing a crafted archive to overwrite arbitrary files on the target system.

If a victim extracts a malicious archive, the attacker can:

* Overwrite sensitive files (e.g., `.bashrc`, `~/.ssh/authorized_keys`, configuration files).
* Potentially gain code execution or unauthorized access.

---

## How it Works

1. An attacker creates a symbolic link pointing to a target file outside the extraction directory.
2. The link is added to a tar archive along with a payload file.
3. When the archive is extracted with a vulnerable version of 7-Zip, the symlink is followed, and the payload overwrites the target file.

---

## Requirements

* **7-Zip** version **older than 25.01**.
* Target must extract the archive with `7z x` or a vulnerable extraction tool.
* The extraction location must allow symlink traversal to the intended target file.

---

## Usage

```bash
./exploit.sh <payload-file> <symlink-target> <output-archive>
```

* **payload-file**: File containing the malicious content to write.
* **symlink-target**: Path to the file you want to overwrite (e.g., `../../.ssh/authorized_keys`).
* **output-archive**: Name of the crafted `.7z` archive.

Example:

```bash
./exploit.sh mykey.pub ../../.ssh/authorized_keys exploit.7z
```

---

## Disclaimer

This PoC is provided **for educational and testing purposes only**.
Do not use it on systems you do not own or have explicit permission to test.
Unauthorized use may violate laws and result in criminal or civil penalties.

---