# CVE-2025-55183

Scanner for React Server Functions source code exposure vulnerability.

## What is this?

CVE-2025-55183: React 19.0.0-19.2.1 Server Actions can be exploited to expose their full source code including hardcoded secrets, API keys, and database credentials.

References:
- https://github.com/facebook/react/commit/894bc73cb493487c48d57f4508e6278db58e673a
- https://vercel.com/kb/bulletin/security-bulletin-cve-2025-55184-and-cve-2025-55183

## Usage

```bash
cd scanner
cargo build --release

# Scan single URL
scanner --url https://example.com

# Scan multiple URLs from file
scanner --file urls.txt
```

Options:
```
--url, -u       Target URL
--file, -f      File with URLs (one per line)
--output, -o    Output directory (default: scan-results)
--cookies, -c   Authentication cookies
--timeout, -t   Request timeout in seconds (default: 30)
--verbose, -v   Verbose output
--save-all, -a  Save all responses
```

## Testing

```bash
# Start vulnerable app
cd vulnerable-app
npm install
npm run dev

# Scan it
cd scanner
scanner --url http://localhost:4444 -v
```

## How it works

1. Extracts Server Action IDs from target page
2. Sends POST requests with `["$F1"]` payload and `Next-Action` header
3. React stringifies the Server Action, exposing full source code
4. Detects secrets in responses (API keys, database URLs, credentials, etc.)
