/*
 * CVE-2025-55130 - Vulnerability Check
 * 
 * Quick check if Node.js version is vulnerable
 * 
 * Run: node check.js
 */

const version = process.version.replace('v', '');
const [major, minor] = version.split('.').map(Number);

const VULN_RANGES = {
    20: { max_minor: 19, patched: '20.20.0' },
    22: { max_minor: 21, patched: '22.22.0' },
    24: { max_minor: 12, patched: '24.13.0' },
    25: { max_minor: 2,  patched: '25.3.0' }
};

console.log(`
 ===============================================
  CVE-2025-55130 // Version Check
 ===============================================
  detected: v${version}
  platform: ${process.platform}/${process.arch}
 ===============================================
`);

const range = VULN_RANGES[major];

if (!range) {
    console.log('[?] version not in known affected range');
    console.log('[?] affected: 20.x, 22.x, 24.x, 25.x');
    process.exit(0);
}

const isVuln = minor <= range.max_minor;

if (isVuln) {
    console.log('[+] VULNERABLE');
    console.log(`[+] vulnerable range: ${major}.0.0 - ${major}.${range.max_minor}.x`);
    console.log(`[+] patched version: ${range.patched}`);
    console.log('');
    console.log('[*] to exploit:');
    console.log('    node --permission --allow-fs-read=. --allow-fs-write=. exploit.js');
} else {
    console.log('[-] NOT VULNERABLE');
    console.log('[-] version appears to be patched');
}

console.log('');
