# PoC for QUIC-LEAK (CVE-2025-54939) in LSQUIC
## Overview

This PoC highlights CVE-2025-54939, a pre-handshake memory exhaustion (Denial of Service) vulnerability in the LSQUIC QUIC implementation.
The issue, named QUIC-LEAK, was first documented by Imperva:
https://www.imperva.com/blog/quic-leak-cve-2025-54939-new-high-risk-pre-handshake-remote-denial-of-service-in-lsquic-quic-implementation/

## Vulnerability

Affected versions
• LSQUIC < 4.3.1
• OpenLiteSpeed < 1.8.4
• LiteSpeed Web Server < 6.3.4

## Issue
A memory leak in lsquic_engine_packet_in, triggered before the handshake, allows remote attackers to exhaust memory and crash the server.

## Replication Steps
```
> Modify poc/entrypoint.sh to specify host. By default, it targets the litespeed container.
> docker compose up --build
> docker stats
```

In addition to what is described in the blogpost, it was observed that the initial QUIC packet does not need to be fully valid (simply 8 bytes SCID and DCID). This point means that more packets could be included than the examples shown in the article


## Disclaimer

This PoC is for educational and authorized security testing only.
Do not use it against systems without explicit permission.
