# CVE-2025-54589 – Copyparty Reflected XSS 
**Author:** Byte Reaper  
## Description  : 
This repository provides a Proof-of-Concept (PoC)  and simple exploit for **CVE-2025-54589**, a reflected Cross-Site Scripting (XSS) vulnerability in **Copyparty ≤ 1.18.6**.  
By injecting crafted JavaScript payloads into the `filter` parameter, this tool automates detection of the vulnerability and logs successful reflections.

## Features  :
- Supports **HTTP** and **HTTPS** targets  
- Optional custom **cookie** and **CA** file support  
- **Auto color-detection** for terminals (disable with `--no-color`)  
- **Verbose** mode for detailed request/response debug  
- **Rate-limit friendly** (configurable delay between requests)  
- Logs all results to `results.txt`  

## References  "  
- NVD Entry: https://nvd.nist.gov/vuln/detail/CVE-2025-54589
  

## Usage  

1. **Compile** the scanner:  
   ```
   gcc exploit.c argparse.c -o exploit -lcurl
   ./exploit -i <IP> -p <PORT> -c <COOKIES_FILE> -a <CA_FILE> -v
   ```
## Example : 
- Verbose Mode :
   ```
   ./exploit -v -i 1.1.1.1 -p 80
   ```
- disable ANSI colors :
   ```
   ./exploit -n -i 1.1.1.1 -p 443  
   ```
2 - Check results.txt for a summary of payloads and server responses.
## License : 
MIT License

