# CVE-2025-54574-Squid-Heap-Buffer-Overflow
Vulnerability Found on Squid Proxy.
CVE-2025-54574 — Critical Heap Buffer Overflow in Squid Proxy

This repository documents the discovery, analysis, and responsible disclosure process of CVE-2025-54574, a critical heap-based buffer overflow in Squid (<6.4) triggered during URN Trivial-HTTP response handling.

The vulnerability allowed an attacker-controlled server to cause out-of-bounds heap writes, memory corruption, and potential disclosure of up to 4KB of heap memory, including sensitive information.

📌 Severity: Critical (CVSS 9.8)
📌 Weakness: CWE-122
📌 Fixed in: Squid 6.4
📌 Discovered by: Guadalupe Colantonio (StarryNight)

🔍 Contents

/analysis/ → Technical explanation and memory analysis

/poc/ → Safe reproduction steps

/logs/ → Sanitized ASan & Valgrind outputs

README.md → Advisory summary

🧠 Summary of the Vulnerability

Due to improper buffer management in Squid’s URN processing subsystem, oversized responses could overflow a fixed-size heap buffer (~4096 bytes). This resulted in memory corruption and unintentional disclosure of heap content.

The bug affected all Squid versions up to 6.3, across multiple Linux distributions shipping outdated builds.

📅 Disclosure Timeline

2025-07-01 — Initial private report

2025-07-02 → 07-29 — Verification & maintainer coordination

2025-07-30 — CVE assigned

2025-07-31 — Advisory published

2025-08-xx — Patch included in Squid 6.4

📄 Official Advisory

GHSA-w4gv-vw3f-29g3
CVE-2025-54574

👤 Author

Guadalupe Colantonio — Security Researcher
🔗 GitHub: your username
📧 colantonioguadalupe@gmail.com
