# CVE-2025-54322 - XSpeeder SXZOS Pre-Auth RCE Scanner

[![License](https://img.shields.io/badge/license-MIT-blue.svg)](LICENSE)
[![Python](https://img.shields.io/badge/python-3.7+-green.svg)](https://www.python.org/)
[![CVE](https://img.shields.io/badge/CVE-2025--54322-red.svg)](https://nvd.nist.gov/)

A multi-threaded vulnerability scanner for CVE-2025-54322, an unauthenticated remote code execution vulnerability in XSpeeder SXZOS firmware affecting ~70,000+ hosts globally.

## 📋 Table of Contents

- [About the Vulnerability](#about-the-vulnerability)
- [Features](#features)
- [Installation](#installation)
- [Usage](#usage)
- [Output](#output)
- [Disclaimer](#disclaimer)
- [Credits](#credits)
- [Author](#author)

## 🔍 About the Vulnerability

**CVE-2025-54322** is a critical pre-authentication remote code execution vulnerability discovered in XSpeeder SXZOS firmware, which powers SD-WAN devices, routers, and edge networking equipment.

### Vulnerability Details

- **CVE ID**: CVE-2025-54322
- **Vendor**: XSpeeder (Chinese networking vendor)
- **Affected Product**: SXZOS Firmware
- **Vulnerability Type**: Pre-Authentication Remote Code Execution (RCE)
- **CVSS Score**: 9.8+ (Critical)
- **Attack Vector**: Network
- **Privileges Required**: None
- **User Interaction**: None
- **Impact**: Complete system compromise with root privileges

### Technical Details

The vulnerability exists in the Django-based web interface of SXZOS firmware:

1. **Vulnerable Endpoint**: `/?title=ABC&oIp=XXX&chkid=[base64_payload]`
2. **Root Cause**: Unsafe use of Python's `eval()` function on base64-decoded user input
3. **Authentication**: None required (pre-auth)
4. **Execution Context**: Root privileges
5. **Affected Hosts**: ~70,000+ publicly accessible devices globally

### Attack Flow
```
1. Calculate time-based nonce for X-SXZ-R header
2. Warm up session via /webInfos/ endpoint
3. Craft malicious payload with bypass string (#sUserCodexsPwd)
4. Base64 encode payload
5. Send exploit with exactly 3 query parameters
6. Server decodes and evaluates payload
7. Commands execute with root privileges
```

### Bypass Mechanisms

The exploit bypasses multiple defense layers:

- **Nginx User-Agent Check**: Spoofed with `SXZ/2.3`
- **Time-based Nonce**: Calculated header `X-SXZ-R: [0-6]`
- **Session Requirement**: Warmed via `/webInfos/`
- **String Filter**: Bypassed with `#sUserCodexsPwd` comment
- **Parameter Count**: Maintains exactly 3 query parameters

## ✨ Features

- ✅ **Multi-threaded scanning** - Concurrent testing of multiple targets
- ✅ **SSL bypass** - Handles self-signed and invalid certificates
- ✅ **Smart retry logic** - 2 retry attempts per target
- ✅ **Clean output** - Shows only vulnerable hosts
- ✅ **Real-time file writing** - Saves results to `vuln-confirm.txt` immediately
- ✅ **Progress tracking** - Live progress updates every 50 hosts
- ✅ **Thread-safe operations** - Safe concurrent file and console operations
- ✅ **Accurate detection** - Regex-based validation of command execution
- ✅ **PoC-matched logic** - Follows original exploit methodology

## 🚀 Installation

### Prerequisites

- Python 3.7 or higher
- pip package manager

### Setup
```bash
# Clone the repository
git clone https://github.com/Sachinart/CVE-2025-54322.git
cd CVE-2025-54322

# Install required dependencies
pip install -r requirements.txt
```

### Dependencies

Create a `requirements.txt` file:
```txt
requests>=2.31.0
urllib3>=2.0.0
```

## 📖 Usage

### Basic Usage
```bash
python3 scanner.py targets.txt
```

### Advanced Usage
```bash
# Scan with custom thread count (default: 10)
python3 scanner.py targets.txt 20

# Scan with maximum threads for faster results
python3 scanner.py targets.txt 50

# Scan with conservative thread count
python3 scanner.py targets.txt 5
```

### Target File Format

Create a `targets.txt` file with one target per line:
```txt
https://192.168.1.100:4433
https://10.0.0.50:8443
https://example.com:4433
http://vulnerable-device.local
```

### Example Session
```bash
$ python3 scanner.py targets.txt 20

╔═══════════════════════════════════════════════════════════════╗
║     XSpeeder SXZOS (CVE-2025-54322) RCE Scanner              ║
║     Pre-Auth Root RCE Vulnerability Checker                   ║
║     Showing: VULNERABLE HOSTS ONLY                            ║
╚═══════════════════════════════════════════════════════════════╝

[*] Loaded 2338 targets from targets.txt
[*] Using 20 concurrent threads
[*] Vulnerable hosts will be saved to: vuln-confirm.txt
[*] Starting scan...

======================================================================
[+] VULNERABLE: https://27.40.80.93:4433
[+] Status: VULNERABLE - RCE Confirmed
[+] HTTP Status: 500
[+] Output: uid=0(root) gid=0(root)
======================================================================

[*] Progress: 50/2338 | Found: 12 vulnerable
[*] Progress: 100/2338 | Found: 24 vulnerable

======================================================================
[*] SCAN COMPLETE
======================================================================
[*] Total Time: 890.45 seconds
[*] Total Targets Scanned: 2338
[*] Vulnerable Hosts Found: 156
[*] Success Rate: 6.67%
======================================================================
```

## 📊 Output

### Console Output

The scanner displays:
- Real-time vulnerable host discoveries
- Progress updates every 50 hosts
- Final summary with statistics
- Clean, organized results

### File Output (`vuln-confirm.txt`)
```txt
XSpeeder SXZOS CVE-2025-54322 - Vulnerable Hosts
Scan started: 2025-12-27 15:30:45
======================================================================

https://27.40.80.93:4433
Status: VULNERABLE - RCE Confirmed
Output: uid=0(root) gid=0(root)
----------------------------------------------------------------------
https://27.40.83.189:4433
Status: VULNERABLE - RCE Confirmed
Output: uid=0(root) gid=0(root)
----------------------------------------------------------------------

======================================================================
Scan completed: 2025-12-27 15:45:30
Total scanned: 2338
Vulnerable: 156
Time taken: 890.45 seconds
```

## 🎯 Thread Recommendations

| Target Count | Recommended Threads | Expected Time |
|--------------|-------------------|---------------|
| 1-10         | 5 threads         | ~1-2 min      |
| 10-50        | 10 threads        | ~3-5 min      |
| 50-100       | 20 threads        | ~5-10 min     |
| 100-500      | 30 threads        | ~10-20 min    |
| 500+         | 40-50 threads     | ~20+ min      |

## ⚠️ Disclaimer

This tool is provided for **educational and authorized security testing purposes only**.

### Legal Notice

- Only test systems you own or have explicit written permission to test
- Unauthorized access to computer systems is illegal in most jurisdictions
- The author assumes no liability for misuse of this tool
- By using this tool, you agree to use it responsibly and ethically
- This tool is for security research and penetration testing only

### Responsible Disclosure

If you discover vulnerable systems:
1. Do not exploit beyond confirming the vulnerability
2. Report findings to the system owner immediately
3. Allow reasonable time for remediation
4. Do not publicly disclose specific vulnerable hosts

### Ethical Use

- **DO**: Use for authorized penetration testing
- **DO**: Use for security research with permission
- **DO**: Report vulnerabilities responsibly
- **DON'T**: Use for unauthorized access
- **DON'T**: Use for malicious purposes
- **DON'T**: Publicly expose vulnerable systems

## 🛡️ Mitigation

### For System Administrators

If you manage XSpeeder SXZOS devices:

1. **Immediately isolate affected devices** from public internet
2. **Implement network segmentation** to limit exposure
3. **Deploy WAF rules** to block exploitation attempts
4. **Monitor logs** for indicators of compromise
5. **Contact XSpeeder** for firmware updates (vendor unresponsive as of publication)
6. **Consider alternative solutions** if vendor remains unresponsive

### Detection

Look for these indicators in logs:
- Requests to `/?title=*&oIp=*&chkid=*` with base64 payloads
- User-Agent: `SXZ/2.3`
- Unusual `X-SXZ-R` headers
- Base64 strings containing `#sUserCodexsPwd`
- Multiple requests to `/webInfos/` followed by root path

### Temporary Workarounds
```nginx
# Nginx rule to block exploitation attempts
location / {
    if ($args ~* "chkid=") {
        return 403;
    }
}
```

## 📚 References

- **Original Disclosure**: [pwn.ai - CVE-2025-54322 Zero-Day](https://pwn.ai/blog/cve-2025-54322-zeroday-unauthenticated-root-rce-affecting-70-000-hosts)
- **NVD Entry**: [CVE-2025-54322](https://nvd.nist.gov/) *(pending)*
- **Vendor**: XSpeeder (unresponsive after 7+ months)

## 🙏 Credits

### Original Vulnerability Discovery

This vulnerability was autonomously discovered by **pwn.ai** - an AI-powered security research platform.

- **Discovery Platform**: [pwn.ai](https://pwn.ai)
- **Original Disclosure**: [pwn.ai Blog Post](https://pwn.ai/blog/cve-2025-54322-zeroday-unauthenticated-root-rce-affecting-70-000-hosts)
- **Discovery Date**: Discovered by pwn.ai agents 10+ months prior to publication
- **Disclosure Timeline**: 7+ months of vendor outreach with no response

**Important Note**: This is the first publicly documented agent-found, remotely exploitable zero-day RCE vulnerability.

## 👨‍💻 Author

**Chirag Artani**

- 🌐 Website: [https://3rag.com](https://3rag.com)
- 🔐 Security Researcher & Penetration Tester

### About the Scanner

This scanner implementation was created to assist security professionals in:
- Identifying vulnerable XSpeeder SXZOS devices in their networks
- Conducting authorized penetration testing engagements
- Validating patch deployment effectiveness
- Security research and awareness

## 📄 License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## 🤝 Contributing

Contributions are welcome! Please feel free to submit a Pull Request.

### Guidelines

1. Follow PEP 8 style guidelines
2. Add comments for complex logic
3. Test thoroughly before submitting
4. Update documentation as needed
5. Ensure ethical use cases only

## 📞 Support

For questions, issues, or suggestions:
- Open an issue on GitHub
- Visit [https://3rag.com](https://3rag.com)
- Follow responsible disclosure practices

---

**Remember**: With great power comes great responsibility. Use this tool ethically and legally.

**Stay Safe. Stay Ethical. Stay Legal.**
