# CVE-2025-5304
PT Project Notebooks 1.0.0 - 1.1.3 - Missing Authorization to Unauthenticated Privilege Escalation
# 🚀 PT Project Notebooks ≤ 1.1.3 — Unauthenticated Privilege Escalation (CVE-2025-5304)

> PoC & exploit helper for **PT Project Notebooks** versions **1.0.0–1.1.3**: Missing authorization in `wpnb_pto_new_users_add()` allows unauthenticated attackers to escalate a chosen user’s privileges to **Administrator** via `admin-ajax.php`.

---

## 🧾 Description

The **PT Project Notebooks** plugin for WordPress is vulnerable to **Privilege Escalation** due to missing authorization in the function **`wpnb_pto_new_users_add()`** in versions **1.0.0 through 1.1.3**. This makes it possible for unauthenticated attackers to elevate privileges to those of an **Administrator** for a specified user ID.

- **CVE:** CVE-2025-5304  
- **CVSS:** **9.8 (Critical)**

---

## 🛠️ What the script does

- **Version check:** Reads `wp-content/plugins/project-notebooks/readme.txt` and extracts the **Stable tag** to confirm the target is ≤ **1.1.3**.  
- **Nonce discovery:** Fetches the site front page and extracts `custom.nonce` and `custom.ajax_url` injected by the plugin into the page (via `wp_localize_script`).  
- **Privilege escalation:** Sends a POST to `admin-ajax.php` with `action=wpnb_pto_new_users_add`, the discovered `nonce`, `ids=<UserID>`, and `user_type=2` to copy all **Administrator** capabilities onto the target user.  
- **Cookie support:** If the nonce is tied to a logged-in session (site/theme behavior), you must pass the matching `wordpress_logged_in_*` cookie for `wp_verify_nonce()` to succeed.  
- **Quiet delay:** Waits 3 seconds before the exploit request (silent mode).

---

## ▶️ Usage

```bash
python3 CVE-2025-5304.py -u "http://TARGET/wordpress" -id 28
python3 CVE-2025-5304.py -u "http://TARGET/wordpress" -id 28 -c "wordpress_logged_in_...=..."
```

---

## 🆘 Built-in Help

```
CVE-2025-5304.py -help
usage: t.py [-h] -u URL -id ID [-c COOKIE] [--skip-version]

CVE-2025-5304 (Nxploited Edition)

options:
  -h, --help           show this help message and exit
  -u, --url URL        Target WordPress site URL (e.g. http://127.0.0.1/wordpress)
  -id, --id ID         User ID to escalate (e.g. 28)
  -c, --cookie COOKIE  Optional Cookie header value for session-bound nonces
  --skip-version       Skip readme.txt version check
```

---

## ⚙️ Options explained

- **`-u / --url`** — Base site URL; the tool normalizes it and reads plugin readme + front page.  
- **`-id / --id`** — WordPress numeric user ID to escalate (Subscriber is enough).  
- **`-c / --cookie`** — Full Cookie header value (e.g., `wordpress_logged_in_*=...`) required if nonce is session-bound.  
- **`--skip-version`** — Skip the readme.txt Stable tag check (useful when readme is hidden or customized).

**Notes on nonce & cookie**  
- If `custom.nonce` is visible in a private/incognito window, it’s public—no cookie needed.  
- If you extracted the nonce while logged in, you must pass the same `wordpress_logged_in_*` cookie with `-c`.  
- The exploit must use the exact `custom.ajax_url` (scheme/host/port/path) shown in the page source.

---

## ⚠️ Disclaimer

This repository, PoC, and code are provided for educational and authorized security testing only. You are solely responsible for ensuring you have explicit permission to test targets. The author assumes no liability for misuse or damages arising from the use of this project.

---

**By: Khaled Alenazi (Nxploited)**
