# CVE-2025-53020 - Apache httpd HTTP/2 Memory Exhaustion PoC

A proof of concept demonstrating [CVE-2025-53020](https://httpd.apache.org/security/vulnerabilities_24.html), a memory exhaustion vulnerability in Apache httpd's HTTP/2 implementation I found in mid-2025.

📖 **Deep dive**: [galbarnahum.com/posts/apache-httpd-cve-2025-53020](https://galbarnahum.com/posts/apache-httpd-cve-2025-53020)

## Vulnerability Overview

Apache httpd is vulnerable to a denial-of-service attack via HTTP/2 header processing. The vulnerability exists due to unnecessary memory duplication when handling repeated header names in HTTP/2 requests.

### Attack Mechanism

1. **HPACK Exploitation**: The attack leverages HTTP/2's HPACK header compression by first sending an initial request to populate the server's HPACK dynamic table with a long header name
2. **Memory Amplification**: Subsequent requests reference this header name multiple times, but the server allocates new memory for each occurrence instead of reusing the existing entry
3. **Resource Exhaustion**: By sending batches of requests with thousands of header repetitions, an attacker can rapidly exhaust server memory

### Impact

- Denial of Service (DoS)
- Server memory exhaustion
- Potential service unavailability

## Requirements

- Python 3.7+
- `h2` - HTTP/2 protocol library
- `tqdm` - Progress bar for attack visualization

## Installation

```bash
pip install h2 tqdm
```

## Usage

### Basic Usage

```bash
python poc.py --url https://target.example.com/
```

### Command Line Arguments

| Argument | Default | Description |
|----------|---------|-------------|
| `--url` | *required* | Target URL (e.g., `https://example.com/path`) |
| `--header-name-length` | 4064 | Length of the header name (max: 4064) |
| `--header-reps` | 2063 | Number of header repetitions per request (recommended max: 2063) |
| `--requests-per-batch` | 1 | Number of requests per batch |
| `--batches` | 100 | Number of batches to send |
| `--delay` | 0 | Delay between batches in seconds |
| `--num-headers-to-repeat` | 1 | Number of different header names to create (uses chars a, b, c, etc.) |

### Examples

**Standard attack against HTTPS target:**
```bash
python poc.py --url https://target.com/api/endpoint
```

**Attack with custom header settings:**
```bash
python poc.py --url http://localhost:8080/test --header-reps 1000 --batches 200
```

**Attack with multiple distinct header names:**
```bash
python poc.py --url https://target.com --num-headers-to-repeat 3 --header-name-length 3000
```

**Slower attack with delay between batches:**
```bash
python poc.py --url https://target.com --delay 0.5 --batches 500
```

## Technical Details

### HPACK Encoder Patch

The PoC includes a patch for the `h2` library's HPACK encoder to correctly handle empty header values. This fixes a bug where the encoder incorrectly indexes headers with empty string values (treating `""` as falsy instead of checking for `None`).

### Constraints

- **Header name length**: Maximum 4064 bytes (limited by HTTP/2 frame constraints)
- **Header repetitions**: Recommended maximum 2063 per request
- **Multiple header names**: When using `--num-headers-to-repeat > 1`, header name length should be < 4000

## Affected Versions

Apache httpd versions vulnerable to CVE-2025-53020. Check the official Apache security advisories for specific version information and patches.

## Disclaimer

⚠️ **This tool is provided for educational and authorized security testing purposes only.**

- Only use this tool against systems you own or have explicit written permission to test
- Unauthorized access to computer systems is illegal
- The authors are not responsible for any misuse or damage caused by this tool
- Always follow responsible disclosure practices

## License

This project is for security research purposes. Use responsibly and ethically.

