# CVE-2025-52694: Advantech SaaS Composer SQL Injection

This repository contains Proof-of-Concept (PoC) tools for **CVE-2025-52694**, a critical unauthenticated SQL Injection vulnerability affecting **Advantech IoTSuite and IoT Edge Products**.

## Vulnerability Overview

| Attribute | Details |
| --- | --- |
| **CVE ID** | CVE-2025-52694 |
| **Vendor** | Advantech |
| **Product** | IoTSuite and IoT Edge Products |
| **Severity** | **Critical** |
| **Vulnerability Type** | SQL Injection (CWE-89) |
| **Affected Endpoint** | `/displays/{filename}.json?org_id=` |

### Affected Versions

* **IoTSuite SaaSComposer** prior to version 3.4.15
* **IoTSuite Growth Linux docker** prior to version V2.0.2
* **IoTSuite Starter Linux docker** prior to version V2.0.2
* **IoT Edge Linux docker** prior to version V2.0.2
* **IoT Edge Windows** prior to version V2.0.2

## Technical Description

The vulnerability exists because the `filename` parameter in the URL path is unsafely concatenated directly into a PostgreSQL query.

* **Attack Vector**: Unauthenticated attackers can inject stacked queries.
* **Mechanism**: By using functions like `pg_sleep()`, an attacker can confirm the vulnerability through time-based analysis.
* **Potential Impact**: Successful exploitation may allow an attacker to dump the entire database, modify sensitive data, or potentially achieve **Remote Code Execution (RCE)** depending on the database's privileges.

## Usage Instructions

This repository provides two primary methods for testing and verification:

### 1. Python PoC Script (`cve-2025-52694-poc.py`)

A standalone script to perform a time-based SQL injection test.

**Execution:**

```bash
python3 cve-2025-52694-poc.py --url <TARGET_URL> --org 1

```

* `--url`: The base URL of the target Advantech instance.
* `--org`: The Organization ID (defaults to 1). You may need to try different values (1-5) to find a valid organization context.

### 2. Nuclei Template (`cve-2025-52694.yaml`)

For automated scanning across multiple targets.

**Execution:**

```bash
nuclei -t cve-2025-52694.yaml -u <TARGET_URL>

```

* The template uses a `clusterbomb` attack to iterate through common `org_id` values.
* It automatically stops at the first successful match (response delay  6s).

## Remediation

* **Apply Patches**: Immediately install the latest security updates provided by Advantech.
* **Input Validation**: Ensure the `filename` parameter is properly sanitized or use parameterized queries to prevent SQL concatenation.

## Disclaimer

This tool is for educational purposes and authorized security testing only. Unauthorized access to computer systems is illegal. The author assumes no liability for any misuse or damage caused by this tool.

---

**Author**: Loi Nguyen Thang (HCMUTE Information Security Club).
